package zio.aws.rds.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class RebootDbClusterRequest(dbClusterIdentifier: String) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.RebootDbClusterRequest = {
    import RebootDbClusterRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.RebootDbClusterRequest
      .builder()
      .dbClusterIdentifier(dbClusterIdentifier: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.rds.model.RebootDbClusterRequest.ReadOnly =
    zio.aws.rds.model.RebootDbClusterRequest.wrap(buildAwsValue())
}
object RebootDbClusterRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.RebootDbClusterRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.RebootDbClusterRequest =
      zio.aws.rds.model.RebootDbClusterRequest(dbClusterIdentifier)
    def dbClusterIdentifier: String
    def getDbClusterIdentifier: ZIO[Any, Nothing, String] =
      ZIO.succeed(dbClusterIdentifier)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.RebootDbClusterRequest
  ) extends zio.aws.rds.model.RebootDbClusterRequest.ReadOnly {
    override val dbClusterIdentifier: String =
      impl.dbClusterIdentifier(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.RebootDbClusterRequest
  ): zio.aws.rds.model.RebootDbClusterRequest.ReadOnly = new Wrapper(impl)
}
