package zio.aws.rds.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ModifyDbParameterGroupResponse(
    dbParameterGroupName: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.ModifyDbParameterGroupResponse = {
    import ModifyDbParameterGroupResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.ModifyDbParameterGroupResponse
      .builder()
      .optionallyWith(
        dbParameterGroupName.map(value => value: java.lang.String)
      )(_.dbParameterGroupName)
      .build()
  }
  def asReadOnly: zio.aws.rds.model.ModifyDbParameterGroupResponse.ReadOnly =
    zio.aws.rds.model.ModifyDbParameterGroupResponse.wrap(buildAwsValue())
}
object ModifyDbParameterGroupResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.ModifyDbParameterGroupResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.ModifyDbParameterGroupResponse =
      zio.aws.rds.model.ModifyDbParameterGroupResponse(
        dbParameterGroupName.map(value => value)
      )
    def dbParameterGroupName: Optional[String]
    def getDbParameterGroupName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("dbParameterGroupName", dbParameterGroupName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.ModifyDbParameterGroupResponse
  ) extends zio.aws.rds.model.ModifyDbParameterGroupResponse.ReadOnly {
    override val dbParameterGroupName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.dbParameterGroupName())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.ModifyDbParameterGroupResponse
  ): zio.aws.rds.model.ModifyDbParameterGroupResponse.ReadOnly = new Wrapper(
    impl
  )
}
