package zio.aws.rds.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeDbInstanceAutomatedBackupsResponse(
    marker: Optional[String] = Optional.Absent,
    dbInstanceAutomatedBackups: Optional[
      Iterable[zio.aws.rds.model.DBInstanceAutomatedBackup]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.DescribeDbInstanceAutomatedBackupsResponse = {
    import DescribeDbInstanceAutomatedBackupsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.DescribeDbInstanceAutomatedBackupsResponse
      .builder()
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .optionallyWith(
        dbInstanceAutomatedBackups.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.dbInstanceAutomatedBackups)
      .build()
  }
  def asReadOnly
      : zio.aws.rds.model.DescribeDbInstanceAutomatedBackupsResponse.ReadOnly =
    zio.aws.rds.model.DescribeDbInstanceAutomatedBackupsResponse
      .wrap(buildAwsValue())
}
object DescribeDbInstanceAutomatedBackupsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.DescribeDbInstanceAutomatedBackupsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.rds.model.DescribeDbInstanceAutomatedBackupsResponse =
      zio.aws.rds.model.DescribeDbInstanceAutomatedBackupsResponse(
        marker.map(value => value),
        dbInstanceAutomatedBackups.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def marker: Optional[String]
    def dbInstanceAutomatedBackups
        : Optional[List[zio.aws.rds.model.DBInstanceAutomatedBackup.ReadOnly]]
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
    def getDbInstanceAutomatedBackups: ZIO[Any, AwsError, List[
      zio.aws.rds.model.DBInstanceAutomatedBackup.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "dbInstanceAutomatedBackups",
      dbInstanceAutomatedBackups
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.DescribeDbInstanceAutomatedBackupsResponse
  ) extends zio.aws.rds.model.DescribeDbInstanceAutomatedBackupsResponse.ReadOnly {
    override val marker: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.marker())
      .map(value => value: String)
    override val dbInstanceAutomatedBackups
        : Optional[List[zio.aws.rds.model.DBInstanceAutomatedBackup.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dbInstanceAutomatedBackups())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.rds.model.DBInstanceAutomatedBackup.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.DescribeDbInstanceAutomatedBackupsResponse
  ): zio.aws.rds.model.DescribeDbInstanceAutomatedBackupsResponse.ReadOnly =
    new Wrapper(impl)
}
