package zio.aws.rds.model
import zio.aws.rds.model.primitives.{CustomEngineVersion, CustomEngineName}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteCustomDbEngineVersionRequest(
    engine: CustomEngineName,
    engineVersion: CustomEngineVersion
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.DeleteCustomDbEngineVersionRequest = {
    import DeleteCustomDbEngineVersionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.DeleteCustomDbEngineVersionRequest
      .builder()
      .engine(CustomEngineName.unwrap(engine): java.lang.String)
      .engineVersion(
        CustomEngineVersion.unwrap(engineVersion): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.rds.model.DeleteCustomDbEngineVersionRequest.ReadOnly =
    zio.aws.rds.model.DeleteCustomDbEngineVersionRequest.wrap(buildAwsValue())
}
object DeleteCustomDbEngineVersionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.DeleteCustomDbEngineVersionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.DeleteCustomDbEngineVersionRequest =
      zio.aws.rds.model
        .DeleteCustomDbEngineVersionRequest(engine, engineVersion)
    def engine: CustomEngineName
    def engineVersion: CustomEngineVersion
    def getEngine: ZIO[Any, Nothing, CustomEngineName] = ZIO.succeed(engine)
    def getEngineVersion: ZIO[Any, Nothing, CustomEngineVersion] =
      ZIO.succeed(engineVersion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.DeleteCustomDbEngineVersionRequest
  ) extends zio.aws.rds.model.DeleteCustomDbEngineVersionRequest.ReadOnly {
    override val engine: CustomEngineName =
      zio.aws.rds.model.primitives.CustomEngineName(impl.engine())
    override val engineVersion: CustomEngineVersion =
      zio.aws.rds.model.primitives.CustomEngineVersion(impl.engineVersion())
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.DeleteCustomDbEngineVersionRequest
  ): zio.aws.rds.model.DeleteCustomDbEngineVersionRequest.ReadOnly =
    new Wrapper(impl)
}
