package zio.aws.rds.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DBParameterGroupStatus(
    dbParameterGroupName: Optional[String] = Optional.Absent,
    parameterApplyStatus: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.DBParameterGroupStatus = {
    import DBParameterGroupStatus.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.DBParameterGroupStatus
      .builder()
      .optionallyWith(
        dbParameterGroupName.map(value => value: java.lang.String)
      )(_.dbParameterGroupName)
      .optionallyWith(
        parameterApplyStatus.map(value => value: java.lang.String)
      )(_.parameterApplyStatus)
      .build()
  }
  def asReadOnly: zio.aws.rds.model.DBParameterGroupStatus.ReadOnly =
    zio.aws.rds.model.DBParameterGroupStatus.wrap(buildAwsValue())
}
object DBParameterGroupStatus {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.DBParameterGroupStatus
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.DBParameterGroupStatus =
      zio.aws.rds.model.DBParameterGroupStatus(
        dbParameterGroupName.map(value => value),
        parameterApplyStatus.map(value => value)
      )
    def dbParameterGroupName: Optional[String]
    def parameterApplyStatus: Optional[String]
    def getDbParameterGroupName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("dbParameterGroupName", dbParameterGroupName)
    def getParameterApplyStatus: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("parameterApplyStatus", parameterApplyStatus)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.DBParameterGroupStatus
  ) extends zio.aws.rds.model.DBParameterGroupStatus.ReadOnly {
    override val dbParameterGroupName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.dbParameterGroupName())
      .map(value => value: String)
    override val parameterApplyStatus: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.parameterApplyStatus())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.DBParameterGroupStatus
  ): zio.aws.rds.model.DBParameterGroupStatus.ReadOnly = new Wrapper(impl)
}
