package zio.aws.rds.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class Subnet(
    subnetIdentifier: scala.Option[String] = None,
    subnetAvailabilityZone: scala.Option[zio.aws.rds.model.AvailabilityZone] =
      None,
    subnetOutpost: scala.Option[zio.aws.rds.model.Outpost] = None,
    subnetStatus: scala.Option[String] = None
) {
  def buildAwsValue(): software.amazon.awssdk.services.rds.model.Subnet = {
    import Subnet.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.Subnet
      .builder()
      .optionallyWith(subnetIdentifier.map(value => value: java.lang.String))(
        _.subnetIdentifier
      )
      .optionallyWith(
        subnetAvailabilityZone.map(value => value.buildAwsValue())
      )(_.subnetAvailabilityZone)
      .optionallyWith(subnetOutpost.map(value => value.buildAwsValue()))(
        _.subnetOutpost
      )
      .optionallyWith(subnetStatus.map(value => value: java.lang.String))(
        _.subnetStatus
      )
      .build()
  }
  def asReadOnly: zio.aws.rds.model.Subnet.ReadOnly =
    zio.aws.rds.model.Subnet.wrap(buildAwsValue())
}
object Subnet {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.rds.model.Subnet] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.Subnet = zio.aws.rds.model.Subnet(
      subnetIdentifier.map(value => value),
      subnetAvailabilityZone.map(value => value.asEditable),
      subnetOutpost.map(value => value.asEditable),
      subnetStatus.map(value => value)
    )
    def subnetIdentifier: scala.Option[String]
    def subnetAvailabilityZone
        : scala.Option[zio.aws.rds.model.AvailabilityZone.ReadOnly]
    def subnetOutpost: scala.Option[zio.aws.rds.model.Outpost.ReadOnly]
    def subnetStatus: scala.Option[String]
    def getSubnetIdentifier: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("subnetIdentifier", subnetIdentifier)
    def getSubnetAvailabilityZone
        : ZIO[Any, AwsError, zio.aws.rds.model.AvailabilityZone.ReadOnly] =
      AwsError.unwrapOptionField(
        "subnetAvailabilityZone",
        subnetAvailabilityZone
      )
    def getSubnetOutpost
        : ZIO[Any, AwsError, zio.aws.rds.model.Outpost.ReadOnly] =
      AwsError.unwrapOptionField("subnetOutpost", subnetOutpost)
    def getSubnetStatus: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("subnetStatus", subnetStatus)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.Subnet
  ) extends zio.aws.rds.model.Subnet.ReadOnly {
    override val subnetIdentifier: scala.Option[String] =
      scala.Option(impl.subnetIdentifier()).map(value => value: String)
    override val subnetAvailabilityZone
        : scala.Option[zio.aws.rds.model.AvailabilityZone.ReadOnly] = scala
      .Option(impl.subnetAvailabilityZone())
      .map(value => zio.aws.rds.model.AvailabilityZone.wrap(value))
    override val subnetOutpost
        : scala.Option[zio.aws.rds.model.Outpost.ReadOnly] = scala
      .Option(impl.subnetOutpost())
      .map(value => zio.aws.rds.model.Outpost.wrap(value))
    override val subnetStatus: scala.Option[String] =
      scala.Option(impl.subnetStatus()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.Subnet
  ): zio.aws.rds.model.Subnet.ReadOnly = new Wrapper(impl)
}
