package zio.aws.rds.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class StopDbClusterResponse(
    dbCluster: scala.Option[zio.aws.rds.model.DBCluster] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.StopDbClusterResponse = {
    import StopDbClusterResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.StopDbClusterResponse
      .builder()
      .optionallyWith(dbCluster.map(value => value.buildAwsValue()))(
        _.dbCluster
      )
      .build()
  }
  def asReadOnly: zio.aws.rds.model.StopDbClusterResponse.ReadOnly =
    zio.aws.rds.model.StopDbClusterResponse.wrap(buildAwsValue())
}
object StopDbClusterResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.StopDbClusterResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.StopDbClusterResponse = zio.aws.rds.model
      .StopDbClusterResponse(dbCluster.map(value => value.asEditable))
    def dbCluster: scala.Option[zio.aws.rds.model.DBCluster.ReadOnly]
    def getDbCluster: ZIO[Any, AwsError, zio.aws.rds.model.DBCluster.ReadOnly] =
      AwsError.unwrapOptionField("dbCluster", dbCluster)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.StopDbClusterResponse
  ) extends zio.aws.rds.model.StopDbClusterResponse.ReadOnly {
    override val dbCluster: scala.Option[zio.aws.rds.model.DBCluster.ReadOnly] =
      scala
        .Option(impl.dbCluster())
        .map(value => zio.aws.rds.model.DBCluster.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.StopDbClusterResponse
  ): zio.aws.rds.model.StopDbClusterResponse.ReadOnly = new Wrapper(impl)
}
