package zio.aws.rds.model
import java.lang.Integer
import zio.aws.rds.model.primitives.{
  LongOptional,
  BooleanOptional,
  IntegerOptional
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class RestoreDbClusterFromS3Request(
    availabilityZones: scala.Option[Iterable[String]] = None,
    backupRetentionPeriod: scala.Option[IntegerOptional] = None,
    characterSetName: scala.Option[String] = None,
    databaseName: scala.Option[String] = None,
    dbClusterIdentifier: String,
    dbClusterParameterGroupName: scala.Option[String] = None,
    vpcSecurityGroupIds: scala.Option[Iterable[String]] = None,
    dbSubnetGroupName: scala.Option[String] = None,
    engine: String,
    engineVersion: scala.Option[String] = None,
    port: scala.Option[IntegerOptional] = None,
    masterUsername: String,
    masterUserPassword: String,
    optionGroupName: scala.Option[String] = None,
    preferredBackupWindow: scala.Option[String] = None,
    preferredMaintenanceWindow: scala.Option[String] = None,
    tags: scala.Option[Iterable[zio.aws.rds.model.Tag]] = None,
    storageEncrypted: scala.Option[BooleanOptional] = None,
    kmsKeyId: scala.Option[String] = None,
    enableIAMDatabaseAuthentication: scala.Option[BooleanOptional] = None,
    sourceEngine: String,
    sourceEngineVersion: String,
    s3BucketName: String,
    s3Prefix: scala.Option[String] = None,
    s3IngestionRoleArn: String,
    backtrackWindow: scala.Option[LongOptional] = None,
    enableCloudwatchLogsExports: scala.Option[Iterable[String]] = None,
    deletionProtection: scala.Option[BooleanOptional] = None,
    copyTagsToSnapshot: scala.Option[BooleanOptional] = None,
    domain: scala.Option[String] = None,
    domainIAMRoleName: scala.Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.RestoreDbClusterFromS3Request = {
    import RestoreDbClusterFromS3Request.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.RestoreDbClusterFromS3Request
      .builder()
      .optionallyWith(
        availabilityZones.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.availabilityZones)
      .optionallyWith(backupRetentionPeriod.map(value => value: Integer))(
        _.backupRetentionPeriod
      )
      .optionallyWith(characterSetName.map(value => value: java.lang.String))(
        _.characterSetName
      )
      .optionallyWith(databaseName.map(value => value: java.lang.String))(
        _.databaseName
      )
      .dbClusterIdentifier(dbClusterIdentifier: java.lang.String)
      .optionallyWith(
        dbClusterParameterGroupName.map(value => value: java.lang.String)
      )(_.dbClusterParameterGroupName)
      .optionallyWith(
        vpcSecurityGroupIds.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.vpcSecurityGroupIds)
      .optionallyWith(dbSubnetGroupName.map(value => value: java.lang.String))(
        _.dbSubnetGroupName
      )
      .engine(engine: java.lang.String)
      .optionallyWith(engineVersion.map(value => value: java.lang.String))(
        _.engineVersion
      )
      .optionallyWith(port.map(value => value: Integer))(_.port)
      .masterUsername(masterUsername: java.lang.String)
      .masterUserPassword(masterUserPassword: java.lang.String)
      .optionallyWith(optionGroupName.map(value => value: java.lang.String))(
        _.optionGroupName
      )
      .optionallyWith(
        preferredBackupWindow.map(value => value: java.lang.String)
      )(_.preferredBackupWindow)
      .optionallyWith(
        preferredMaintenanceWindow.map(value => value: java.lang.String)
      )(_.preferredMaintenanceWindow)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(storageEncrypted.map(value => value: java.lang.Boolean))(
        _.storageEncrypted
      )
      .optionallyWith(kmsKeyId.map(value => value: java.lang.String))(
        _.kmsKeyId
      )
      .optionallyWith(
        enableIAMDatabaseAuthentication.map(value => value: java.lang.Boolean)
      )(_.enableIAMDatabaseAuthentication)
      .sourceEngine(sourceEngine: java.lang.String)
      .sourceEngineVersion(sourceEngineVersion: java.lang.String)
      .s3BucketName(s3BucketName: java.lang.String)
      .optionallyWith(s3Prefix.map(value => value: java.lang.String))(
        _.s3Prefix
      )
      .s3IngestionRoleArn(s3IngestionRoleArn: java.lang.String)
      .optionallyWith(backtrackWindow.map(value => value: java.lang.Long))(
        _.backtrackWindow
      )
      .optionallyWith(
        enableCloudwatchLogsExports.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.enableCloudwatchLogsExports)
      .optionallyWith(
        deletionProtection.map(value => value: java.lang.Boolean)
      )(_.deletionProtection)
      .optionallyWith(
        copyTagsToSnapshot.map(value => value: java.lang.Boolean)
      )(_.copyTagsToSnapshot)
      .optionallyWith(domain.map(value => value: java.lang.String))(_.domain)
      .optionallyWith(domainIAMRoleName.map(value => value: java.lang.String))(
        _.domainIAMRoleName
      )
      .build()
  }
  def asReadOnly: zio.aws.rds.model.RestoreDbClusterFromS3Request.ReadOnly =
    zio.aws.rds.model.RestoreDbClusterFromS3Request.wrap(buildAwsValue())
}
object RestoreDbClusterFromS3Request {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.RestoreDbClusterFromS3Request
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.RestoreDbClusterFromS3Request =
      zio.aws.rds.model.RestoreDbClusterFromS3Request(
        availabilityZones.map(value => value),
        backupRetentionPeriod.map(value => value),
        characterSetName.map(value => value),
        databaseName.map(value => value),
        dbClusterIdentifier,
        dbClusterParameterGroupName.map(value => value),
        vpcSecurityGroupIds.map(value => value),
        dbSubnetGroupName.map(value => value),
        engine,
        engineVersion.map(value => value),
        port.map(value => value),
        masterUsername,
        masterUserPassword,
        optionGroupName.map(value => value),
        preferredBackupWindow.map(value => value),
        preferredMaintenanceWindow.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        storageEncrypted.map(value => value),
        kmsKeyId.map(value => value),
        enableIAMDatabaseAuthentication.map(value => value),
        sourceEngine,
        sourceEngineVersion,
        s3BucketName,
        s3Prefix.map(value => value),
        s3IngestionRoleArn,
        backtrackWindow.map(value => value),
        enableCloudwatchLogsExports.map(value => value),
        deletionProtection.map(value => value),
        copyTagsToSnapshot.map(value => value),
        domain.map(value => value),
        domainIAMRoleName.map(value => value)
      )
    def availabilityZones: scala.Option[List[String]]
    def backupRetentionPeriod: scala.Option[IntegerOptional]
    def characterSetName: scala.Option[String]
    def databaseName: scala.Option[String]
    def dbClusterIdentifier: String
    def dbClusterParameterGroupName: scala.Option[String]
    def vpcSecurityGroupIds: scala.Option[List[String]]
    def dbSubnetGroupName: scala.Option[String]
    def engine: String
    def engineVersion: scala.Option[String]
    def port: scala.Option[IntegerOptional]
    def masterUsername: String
    def masterUserPassword: String
    def optionGroupName: scala.Option[String]
    def preferredBackupWindow: scala.Option[String]
    def preferredMaintenanceWindow: scala.Option[String]
    def tags: scala.Option[List[zio.aws.rds.model.Tag.ReadOnly]]
    def storageEncrypted: scala.Option[BooleanOptional]
    def kmsKeyId: scala.Option[String]
    def enableIAMDatabaseAuthentication: scala.Option[BooleanOptional]
    def sourceEngine: String
    def sourceEngineVersion: String
    def s3BucketName: String
    def s3Prefix: scala.Option[String]
    def s3IngestionRoleArn: String
    def backtrackWindow: scala.Option[LongOptional]
    def enableCloudwatchLogsExports: scala.Option[List[String]]
    def deletionProtection: scala.Option[BooleanOptional]
    def copyTagsToSnapshot: scala.Option[BooleanOptional]
    def domain: scala.Option[String]
    def domainIAMRoleName: scala.Option[String]
    def getAvailabilityZones: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("availabilityZones", availabilityZones)
    def getBackupRetentionPeriod: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("backupRetentionPeriod", backupRetentionPeriod)
    def getCharacterSetName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("characterSetName", characterSetName)
    def getDatabaseName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("databaseName", databaseName)
    def getDbClusterIdentifier: ZIO[Any, Nothing, String] =
      ZIO.succeed(dbClusterIdentifier)
    def getDbClusterParameterGroupName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "dbClusterParameterGroupName",
        dbClusterParameterGroupName
      )
    def getVpcSecurityGroupIds: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("vpcSecurityGroupIds", vpcSecurityGroupIds)
    def getDbSubnetGroupName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("dbSubnetGroupName", dbSubnetGroupName)
    def getEngine: ZIO[Any, Nothing, String] = ZIO.succeed(engine)
    def getEngineVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("engineVersion", engineVersion)
    def getPort: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("port", port)
    def getMasterUsername: ZIO[Any, Nothing, String] =
      ZIO.succeed(masterUsername)
    def getMasterUserPassword: ZIO[Any, Nothing, String] =
      ZIO.succeed(masterUserPassword)
    def getOptionGroupName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("optionGroupName", optionGroupName)
    def getPreferredBackupWindow: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("preferredBackupWindow", preferredBackupWindow)
    def getPreferredMaintenanceWindow: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "preferredMaintenanceWindow",
        preferredMaintenanceWindow
      )
    def getTags: ZIO[Any, AwsError, List[zio.aws.rds.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getStorageEncrypted: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("storageEncrypted", storageEncrypted)
    def getKmsKeyId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("kmsKeyId", kmsKeyId)
    def getEnableIAMDatabaseAuthentication
        : ZIO[Any, AwsError, BooleanOptional] = AwsError.unwrapOptionField(
      "enableIAMDatabaseAuthentication",
      enableIAMDatabaseAuthentication
    )
    def getSourceEngine: ZIO[Any, Nothing, String] = ZIO.succeed(sourceEngine)
    def getSourceEngineVersion: ZIO[Any, Nothing, String] =
      ZIO.succeed(sourceEngineVersion)
    def getS3BucketName: ZIO[Any, Nothing, String] = ZIO.succeed(s3BucketName)
    def getS3Prefix: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("s3Prefix", s3Prefix)
    def getS3IngestionRoleArn: ZIO[Any, Nothing, String] =
      ZIO.succeed(s3IngestionRoleArn)
    def getBacktrackWindow: ZIO[Any, AwsError, LongOptional] =
      AwsError.unwrapOptionField("backtrackWindow", backtrackWindow)
    def getEnableCloudwatchLogsExports: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField(
        "enableCloudwatchLogsExports",
        enableCloudwatchLogsExports
      )
    def getDeletionProtection: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("deletionProtection", deletionProtection)
    def getCopyTagsToSnapshot: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("copyTagsToSnapshot", copyTagsToSnapshot)
    def getDomain: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("domain", domain)
    def getDomainIAMRoleName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("domainIAMRoleName", domainIAMRoleName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.RestoreDbClusterFromS3Request
  ) extends zio.aws.rds.model.RestoreDbClusterFromS3Request.ReadOnly {
    override val availabilityZones: scala.Option[List[String]] = scala
      .Option(impl.availabilityZones())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val backupRetentionPeriod: scala.Option[IntegerOptional] = scala
      .Option(impl.backupRetentionPeriod())
      .map(value => value: IntegerOptional)
    override val characterSetName: scala.Option[String] =
      scala.Option(impl.characterSetName()).map(value => value: String)
    override val databaseName: scala.Option[String] =
      scala.Option(impl.databaseName()).map(value => value: String)
    override val dbClusterIdentifier: String =
      impl.dbClusterIdentifier(): String
    override val dbClusterParameterGroupName: scala.Option[String] = scala
      .Option(impl.dbClusterParameterGroupName())
      .map(value => value: String)
    override val vpcSecurityGroupIds: scala.Option[List[String]] = scala
      .Option(impl.vpcSecurityGroupIds())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val dbSubnetGroupName: scala.Option[String] =
      scala.Option(impl.dbSubnetGroupName()).map(value => value: String)
    override val engine: String = impl.engine(): String
    override val engineVersion: scala.Option[String] =
      scala.Option(impl.engineVersion()).map(value => value: String)
    override val port: scala.Option[IntegerOptional] =
      scala.Option(impl.port()).map(value => value: IntegerOptional)
    override val masterUsername: String = impl.masterUsername(): String
    override val masterUserPassword: String = impl.masterUserPassword(): String
    override val optionGroupName: scala.Option[String] =
      scala.Option(impl.optionGroupName()).map(value => value: String)
    override val preferredBackupWindow: scala.Option[String] =
      scala.Option(impl.preferredBackupWindow()).map(value => value: String)
    override val preferredMaintenanceWindow: scala.Option[String] = scala
      .Option(impl.preferredMaintenanceWindow())
      .map(value => value: String)
    override val tags: scala.Option[List[zio.aws.rds.model.Tag.ReadOnly]] =
      scala
        .Option(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.rds.model.Tag.wrap(item)
          }.toList
        )
    override val storageEncrypted: scala.Option[BooleanOptional] =
      scala.Option(impl.storageEncrypted()).map(value => value: BooleanOptional)
    override val kmsKeyId: scala.Option[String] =
      scala.Option(impl.kmsKeyId()).map(value => value: String)
    override val enableIAMDatabaseAuthentication
        : scala.Option[BooleanOptional] = scala
      .Option(impl.enableIAMDatabaseAuthentication())
      .map(value => value: BooleanOptional)
    override val sourceEngine: String = impl.sourceEngine(): String
    override val sourceEngineVersion: String =
      impl.sourceEngineVersion(): String
    override val s3BucketName: String = impl.s3BucketName(): String
    override val s3Prefix: scala.Option[String] =
      scala.Option(impl.s3Prefix()).map(value => value: String)
    override val s3IngestionRoleArn: String = impl.s3IngestionRoleArn(): String
    override val backtrackWindow: scala.Option[LongOptional] =
      scala.Option(impl.backtrackWindow()).map(value => value: LongOptional)
    override val enableCloudwatchLogsExports: scala.Option[List[String]] = scala
      .Option(impl.enableCloudwatchLogsExports())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val deletionProtection: scala.Option[BooleanOptional] = scala
      .Option(impl.deletionProtection())
      .map(value => value: BooleanOptional)
    override val copyTagsToSnapshot: scala.Option[BooleanOptional] = scala
      .Option(impl.copyTagsToSnapshot())
      .map(value => value: BooleanOptional)
    override val domain: scala.Option[String] =
      scala.Option(impl.domain()).map(value => value: String)
    override val domainIAMRoleName: scala.Option[String] =
      scala.Option(impl.domainIAMRoleName()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.RestoreDbClusterFromS3Request
  ): zio.aws.rds.model.RestoreDbClusterFromS3Request.ReadOnly = new Wrapper(
    impl
  )
}
