package zio.aws.rds.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class RemoveRoleFromDbClusterRequest(
    dbClusterIdentifier: String,
    roleArn: String,
    featureName: scala.Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.RemoveRoleFromDbClusterRequest = {
    import RemoveRoleFromDbClusterRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.RemoveRoleFromDbClusterRequest
      .builder()
      .dbClusterIdentifier(dbClusterIdentifier: java.lang.String)
      .roleArn(roleArn: java.lang.String)
      .optionallyWith(featureName.map(value => value: java.lang.String))(
        _.featureName
      )
      .build()
  }
  def asReadOnly: zio.aws.rds.model.RemoveRoleFromDbClusterRequest.ReadOnly =
    zio.aws.rds.model.RemoveRoleFromDbClusterRequest.wrap(buildAwsValue())
}
object RemoveRoleFromDbClusterRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.RemoveRoleFromDbClusterRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.RemoveRoleFromDbClusterRequest =
      zio.aws.rds.model.RemoveRoleFromDbClusterRequest(
        dbClusterIdentifier,
        roleArn,
        featureName.map(value => value)
      )
    def dbClusterIdentifier: String
    def roleArn: String
    def featureName: scala.Option[String]
    def getDbClusterIdentifier: ZIO[Any, Nothing, String] =
      ZIO.succeed(dbClusterIdentifier)
    def getRoleArn: ZIO[Any, Nothing, String] = ZIO.succeed(roleArn)
    def getFeatureName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("featureName", featureName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.RemoveRoleFromDbClusterRequest
  ) extends zio.aws.rds.model.RemoveRoleFromDbClusterRequest.ReadOnly {
    override val dbClusterIdentifier: String =
      impl.dbClusterIdentifier(): String
    override val roleArn: String = impl.roleArn(): String
    override val featureName: scala.Option[String] =
      scala.Option(impl.featureName()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.RemoveRoleFromDbClusterRequest
  ): zio.aws.rds.model.RemoveRoleFromDbClusterRequest.ReadOnly = new Wrapper(
    impl
  )
}
