package zio.aws.rds.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class RegisterDbProxyTargetsRequest(
    dbProxyName: String,
    targetGroupName: scala.Option[String] = None,
    dbInstanceIdentifiers: scala.Option[Iterable[String]] = None,
    dbClusterIdentifiers: scala.Option[Iterable[String]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.RegisterDbProxyTargetsRequest = {
    import RegisterDbProxyTargetsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.RegisterDbProxyTargetsRequest
      .builder()
      .dbProxyName(dbProxyName: java.lang.String)
      .optionallyWith(targetGroupName.map(value => value: java.lang.String))(
        _.targetGroupName
      )
      .optionallyWith(
        dbInstanceIdentifiers.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.dbInstanceIdentifiers)
      .optionallyWith(
        dbClusterIdentifiers.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.dbClusterIdentifiers)
      .build()
  }
  def asReadOnly: zio.aws.rds.model.RegisterDbProxyTargetsRequest.ReadOnly =
    zio.aws.rds.model.RegisterDbProxyTargetsRequest.wrap(buildAwsValue())
}
object RegisterDbProxyTargetsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.RegisterDbProxyTargetsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.RegisterDbProxyTargetsRequest =
      zio.aws.rds.model.RegisterDbProxyTargetsRequest(
        dbProxyName,
        targetGroupName.map(value => value),
        dbInstanceIdentifiers.map(value => value),
        dbClusterIdentifiers.map(value => value)
      )
    def dbProxyName: String
    def targetGroupName: scala.Option[String]
    def dbInstanceIdentifiers: scala.Option[List[String]]
    def dbClusterIdentifiers: scala.Option[List[String]]
    def getDbProxyName: ZIO[Any, Nothing, String] = ZIO.succeed(dbProxyName)
    def getTargetGroupName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("targetGroupName", targetGroupName)
    def getDbInstanceIdentifiers: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("dbInstanceIdentifiers", dbInstanceIdentifiers)
    def getDbClusterIdentifiers: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("dbClusterIdentifiers", dbClusterIdentifiers)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.RegisterDbProxyTargetsRequest
  ) extends zio.aws.rds.model.RegisterDbProxyTargetsRequest.ReadOnly {
    override val dbProxyName: String = impl.dbProxyName(): String
    override val targetGroupName: scala.Option[String] =
      scala.Option(impl.targetGroupName()).map(value => value: String)
    override val dbInstanceIdentifiers: scala.Option[List[String]] = scala
      .Option(impl.dbInstanceIdentifiers())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val dbClusterIdentifiers: scala.Option[List[String]] = scala
      .Option(impl.dbClusterIdentifiers())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.RegisterDbProxyTargetsRequest
  ): zio.aws.rds.model.RegisterDbProxyTargetsRequest.ReadOnly = new Wrapper(
    impl
  )
}
