package zio.aws.rds.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ModifyDbClusterSnapshotAttributeRequest(
    dbClusterSnapshotIdentifier: String,
    attributeName: String,
    valuesToAdd: scala.Option[Iterable[String]] = None,
    valuesToRemove: scala.Option[Iterable[String]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.ModifyDbClusterSnapshotAttributeRequest = {
    import ModifyDbClusterSnapshotAttributeRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.ModifyDbClusterSnapshotAttributeRequest
      .builder()
      .dbClusterSnapshotIdentifier(
        dbClusterSnapshotIdentifier: java.lang.String
      )
      .attributeName(attributeName: java.lang.String)
      .optionallyWith(
        valuesToAdd.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.valuesToAdd)
      .optionallyWith(
        valuesToRemove.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.valuesToRemove)
      .build()
  }
  def asReadOnly
      : zio.aws.rds.model.ModifyDbClusterSnapshotAttributeRequest.ReadOnly =
    zio.aws.rds.model.ModifyDbClusterSnapshotAttributeRequest
      .wrap(buildAwsValue())
}
object ModifyDbClusterSnapshotAttributeRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.ModifyDbClusterSnapshotAttributeRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.ModifyDbClusterSnapshotAttributeRequest =
      zio.aws.rds.model.ModifyDbClusterSnapshotAttributeRequest(
        dbClusterSnapshotIdentifier,
        attributeName,
        valuesToAdd.map(value => value),
        valuesToRemove.map(value => value)
      )
    def dbClusterSnapshotIdentifier: String
    def attributeName: String
    def valuesToAdd: scala.Option[List[String]]
    def valuesToRemove: scala.Option[List[String]]
    def getDbClusterSnapshotIdentifier: ZIO[Any, Nothing, String] =
      ZIO.succeed(dbClusterSnapshotIdentifier)
    def getAttributeName: ZIO[Any, Nothing, String] = ZIO.succeed(attributeName)
    def getValuesToAdd: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("valuesToAdd", valuesToAdd)
    def getValuesToRemove: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("valuesToRemove", valuesToRemove)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.ModifyDbClusterSnapshotAttributeRequest
  ) extends zio.aws.rds.model.ModifyDbClusterSnapshotAttributeRequest.ReadOnly {
    override val dbClusterSnapshotIdentifier: String =
      impl.dbClusterSnapshotIdentifier(): String
    override val attributeName: String = impl.attributeName(): String
    override val valuesToAdd: scala.Option[List[String]] = scala
      .Option(impl.valuesToAdd())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val valuesToRemove: scala.Option[List[String]] = scala
      .Option(impl.valuesToRemove())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.ModifyDbClusterSnapshotAttributeRequest
  ): zio.aws.rds.model.ModifyDbClusterSnapshotAttributeRequest.ReadOnly =
    new Wrapper(impl)
}
