package zio.aws.rds.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DownloadDbLogFilePortionResponse(
    logFileData: scala.Option[String] = None,
    marker: scala.Option[String] = None,
    additionalDataPending: scala.Option[Boolean] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.DownloadDbLogFilePortionResponse = {
    import DownloadDbLogFilePortionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.DownloadDbLogFilePortionResponse
      .builder()
      .optionallyWith(logFileData.map(value => value: java.lang.String))(
        _.logFileData
      )
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .optionallyWith(
        additionalDataPending.map(value => value: java.lang.Boolean)
      )(_.additionalDataPending)
      .build()
  }
  def asReadOnly: zio.aws.rds.model.DownloadDbLogFilePortionResponse.ReadOnly =
    zio.aws.rds.model.DownloadDbLogFilePortionResponse.wrap(buildAwsValue())
}
object DownloadDbLogFilePortionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.DownloadDbLogFilePortionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.DownloadDbLogFilePortionResponse =
      zio.aws.rds.model.DownloadDbLogFilePortionResponse(
        logFileData.map(value => value),
        marker.map(value => value),
        additionalDataPending.map(value => value)
      )
    def logFileData: scala.Option[String]
    def marker: scala.Option[String]
    def additionalDataPending: scala.Option[Boolean]
    def getLogFileData: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("logFileData", logFileData)
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
    def getAdditionalDataPending: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("additionalDataPending", additionalDataPending)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.DownloadDbLogFilePortionResponse
  ) extends zio.aws.rds.model.DownloadDbLogFilePortionResponse.ReadOnly {
    override val logFileData: scala.Option[String] =
      scala.Option(impl.logFileData()).map(value => value: String)
    override val marker: scala.Option[String] =
      scala.Option(impl.marker()).map(value => value: String)
    override val additionalDataPending: scala.Option[Boolean] =
      scala.Option(impl.additionalDataPending()).map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.DownloadDbLogFilePortionResponse
  ): zio.aws.rds.model.DownloadDbLogFilePortionResponse.ReadOnly = new Wrapper(
    impl
  )
}
