package zio.aws.rds.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeInstallationMediaResponse(
    marker: scala.Option[String] = None,
    installationMedia: scala.Option[Iterable[
      zio.aws.rds.model.InstallationMedia
    ]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.DescribeInstallationMediaResponse = {
    import DescribeInstallationMediaResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.DescribeInstallationMediaResponse
      .builder()
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .optionallyWith(
        installationMedia.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.installationMedia)
      .build()
  }
  def asReadOnly: zio.aws.rds.model.DescribeInstallationMediaResponse.ReadOnly =
    zio.aws.rds.model.DescribeInstallationMediaResponse.wrap(buildAwsValue())
}
object DescribeInstallationMediaResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.DescribeInstallationMediaResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.DescribeInstallationMediaResponse =
      zio.aws.rds.model.DescribeInstallationMediaResponse(
        marker.map(value => value),
        installationMedia.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def marker: scala.Option[String]
    def installationMedia
        : scala.Option[List[zio.aws.rds.model.InstallationMedia.ReadOnly]]
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
    def getInstallationMedia: ZIO[Any, AwsError, List[
      zio.aws.rds.model.InstallationMedia.ReadOnly
    ]] = AwsError.unwrapOptionField("installationMedia", installationMedia)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.DescribeInstallationMediaResponse
  ) extends zio.aws.rds.model.DescribeInstallationMediaResponse.ReadOnly {
    override val marker: scala.Option[String] =
      scala.Option(impl.marker()).map(value => value: String)
    override val installationMedia
        : scala.Option[List[zio.aws.rds.model.InstallationMedia.ReadOnly]] =
      scala
        .Option(impl.installationMedia())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.rds.model.InstallationMedia.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.DescribeInstallationMediaResponse
  ): zio.aws.rds.model.DescribeInstallationMediaResponse.ReadOnly = new Wrapper(
    impl
  )
}
