package zio.aws.rds.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeEngineDefaultParametersResponse(
    engineDefaults: scala.Option[zio.aws.rds.model.EngineDefaults] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.DescribeEngineDefaultParametersResponse = {
    import DescribeEngineDefaultParametersResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.DescribeEngineDefaultParametersResponse
      .builder()
      .optionallyWith(engineDefaults.map(value => value.buildAwsValue()))(
        _.engineDefaults
      )
      .build()
  }
  def asReadOnly
      : zio.aws.rds.model.DescribeEngineDefaultParametersResponse.ReadOnly =
    zio.aws.rds.model.DescribeEngineDefaultParametersResponse
      .wrap(buildAwsValue())
}
object DescribeEngineDefaultParametersResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.DescribeEngineDefaultParametersResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.DescribeEngineDefaultParametersResponse =
      zio.aws.rds.model.DescribeEngineDefaultParametersResponse(
        engineDefaults.map(value => value.asEditable)
      )
    def engineDefaults: scala.Option[zio.aws.rds.model.EngineDefaults.ReadOnly]
    def getEngineDefaults
        : ZIO[Any, AwsError, zio.aws.rds.model.EngineDefaults.ReadOnly] =
      AwsError.unwrapOptionField("engineDefaults", engineDefaults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.DescribeEngineDefaultParametersResponse
  ) extends zio.aws.rds.model.DescribeEngineDefaultParametersResponse.ReadOnly {
    override val engineDefaults
        : scala.Option[zio.aws.rds.model.EngineDefaults.ReadOnly] = scala
      .Option(impl.engineDefaults())
      .map(value => zio.aws.rds.model.EngineDefaults.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.DescribeEngineDefaultParametersResponse
  ): zio.aws.rds.model.DescribeEngineDefaultParametersResponse.ReadOnly =
    new Wrapper(impl)
}
