package zio.aws.rds.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeDbClusterParametersResponse(
    parameters: scala.Option[Iterable[zio.aws.rds.model.Parameter]] = None,
    marker: scala.Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.DescribeDbClusterParametersResponse = {
    import DescribeDbClusterParametersResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.DescribeDbClusterParametersResponse
      .builder()
      .optionallyWith(
        parameters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.parameters)
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .build()
  }
  def asReadOnly
      : zio.aws.rds.model.DescribeDbClusterParametersResponse.ReadOnly =
    zio.aws.rds.model.DescribeDbClusterParametersResponse.wrap(buildAwsValue())
}
object DescribeDbClusterParametersResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.DescribeDbClusterParametersResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.DescribeDbClusterParametersResponse =
      zio.aws.rds.model.DescribeDbClusterParametersResponse(
        parameters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        marker.map(value => value)
      )
    def parameters: scala.Option[List[zio.aws.rds.model.Parameter.ReadOnly]]
    def marker: scala.Option[String]
    def getParameters
        : ZIO[Any, AwsError, List[zio.aws.rds.model.Parameter.ReadOnly]] =
      AwsError.unwrapOptionField("parameters", parameters)
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.DescribeDbClusterParametersResponse
  ) extends zio.aws.rds.model.DescribeDbClusterParametersResponse.ReadOnly {
    override val parameters
        : scala.Option[List[zio.aws.rds.model.Parameter.ReadOnly]] = scala
      .Option(impl.parameters())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.rds.model.Parameter.wrap(item)
        }.toList
      )
    override val marker: scala.Option[String] =
      scala.Option(impl.marker()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.DescribeDbClusterParametersResponse
  ): zio.aws.rds.model.DescribeDbClusterParametersResponse.ReadOnly =
    new Wrapper(impl)
}
