package zio.aws.rds.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DeleteDbClusterSnapshotResponse(
    dbClusterSnapshot: scala.Option[zio.aws.rds.model.DBClusterSnapshot] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.DeleteDbClusterSnapshotResponse = {
    import DeleteDbClusterSnapshotResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.DeleteDbClusterSnapshotResponse
      .builder()
      .optionallyWith(dbClusterSnapshot.map(value => value.buildAwsValue()))(
        _.dbClusterSnapshot
      )
      .build()
  }
  def asReadOnly: zio.aws.rds.model.DeleteDbClusterSnapshotResponse.ReadOnly =
    zio.aws.rds.model.DeleteDbClusterSnapshotResponse.wrap(buildAwsValue())
}
object DeleteDbClusterSnapshotResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.DeleteDbClusterSnapshotResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.DeleteDbClusterSnapshotResponse =
      zio.aws.rds.model.DeleteDbClusterSnapshotResponse(
        dbClusterSnapshot.map(value => value.asEditable)
      )
    def dbClusterSnapshot
        : scala.Option[zio.aws.rds.model.DBClusterSnapshot.ReadOnly]
    def getDbClusterSnapshot
        : ZIO[Any, AwsError, zio.aws.rds.model.DBClusterSnapshot.ReadOnly] =
      AwsError.unwrapOptionField("dbClusterSnapshot", dbClusterSnapshot)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.DeleteDbClusterSnapshotResponse
  ) extends zio.aws.rds.model.DeleteDbClusterSnapshotResponse.ReadOnly {
    override val dbClusterSnapshot
        : scala.Option[zio.aws.rds.model.DBClusterSnapshot.ReadOnly] = scala
      .Option(impl.dbClusterSnapshot())
      .map(value => zio.aws.rds.model.DBClusterSnapshot.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.DeleteDbClusterSnapshotResponse
  ): zio.aws.rds.model.DeleteDbClusterSnapshotResponse.ReadOnly = new Wrapper(
    impl
  )
}
