package zio.aws.rds.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DBSnapshotAttributesResult(
    dbSnapshotIdentifier: scala.Option[String] = None,
    dbSnapshotAttributes: scala.Option[Iterable[
      zio.aws.rds.model.DBSnapshotAttribute
    ]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.DBSnapshotAttributesResult = {
    import DBSnapshotAttributesResult.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.DBSnapshotAttributesResult
      .builder()
      .optionallyWith(
        dbSnapshotIdentifier.map(value => value: java.lang.String)
      )(_.dbSnapshotIdentifier)
      .optionallyWith(
        dbSnapshotAttributes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.dbSnapshotAttributes)
      .build()
  }
  def asReadOnly: zio.aws.rds.model.DBSnapshotAttributesResult.ReadOnly =
    zio.aws.rds.model.DBSnapshotAttributesResult.wrap(buildAwsValue())
}
object DBSnapshotAttributesResult {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.DBSnapshotAttributesResult
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.DBSnapshotAttributesResult =
      zio.aws.rds.model.DBSnapshotAttributesResult(
        dbSnapshotIdentifier.map(value => value),
        dbSnapshotAttributes.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def dbSnapshotIdentifier: scala.Option[String]
    def dbSnapshotAttributes
        : scala.Option[List[zio.aws.rds.model.DBSnapshotAttribute.ReadOnly]]
    def getDbSnapshotIdentifier: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("dbSnapshotIdentifier", dbSnapshotIdentifier)
    def getDbSnapshotAttributes: ZIO[Any, AwsError, List[
      zio.aws.rds.model.DBSnapshotAttribute.ReadOnly
    ]] =
      AwsError.unwrapOptionField("dbSnapshotAttributes", dbSnapshotAttributes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.DBSnapshotAttributesResult
  ) extends zio.aws.rds.model.DBSnapshotAttributesResult.ReadOnly {
    override val dbSnapshotIdentifier: scala.Option[String] =
      scala.Option(impl.dbSnapshotIdentifier()).map(value => value: String)
    override val dbSnapshotAttributes
        : scala.Option[List[zio.aws.rds.model.DBSnapshotAttribute.ReadOnly]] =
      scala
        .Option(impl.dbSnapshotAttributes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.rds.model.DBSnapshotAttribute.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.DBSnapshotAttributesResult
  ): zio.aws.rds.model.DBSnapshotAttributesResult.ReadOnly = new Wrapper(impl)
}
