package zio.aws.rds.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DBClusterSnapshotAttribute(
    attributeName: scala.Option[String] = None,
    attributeValues: scala.Option[Iterable[String]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.DBClusterSnapshotAttribute = {
    import DBClusterSnapshotAttribute.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.DBClusterSnapshotAttribute
      .builder()
      .optionallyWith(attributeName.map(value => value: java.lang.String))(
        _.attributeName
      )
      .optionallyWith(
        attributeValues.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.attributeValues)
      .build()
  }
  def asReadOnly: zio.aws.rds.model.DBClusterSnapshotAttribute.ReadOnly =
    zio.aws.rds.model.DBClusterSnapshotAttribute.wrap(buildAwsValue())
}
object DBClusterSnapshotAttribute {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.DBClusterSnapshotAttribute
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.DBClusterSnapshotAttribute =
      zio.aws.rds.model.DBClusterSnapshotAttribute(
        attributeName.map(value => value),
        attributeValues.map(value => value)
      )
    def attributeName: scala.Option[String]
    def attributeValues: scala.Option[List[String]]
    def getAttributeName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("attributeName", attributeName)
    def getAttributeValues: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("attributeValues", attributeValues)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.DBClusterSnapshotAttribute
  ) extends zio.aws.rds.model.DBClusterSnapshotAttribute.ReadOnly {
    override val attributeName: scala.Option[String] =
      scala.Option(impl.attributeName()).map(value => value: String)
    override val attributeValues: scala.Option[List[String]] = scala
      .Option(impl.attributeValues())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.DBClusterSnapshotAttribute
  ): zio.aws.rds.model.DBClusterSnapshotAttribute.ReadOnly = new Wrapper(impl)
}
