package zio.aws.rds.model
import zio.aws.rds.model.primitives.{Integer, TStamp}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class DBClusterSnapshot(
    availabilityZones: scala.Option[Iterable[String]] = None,
    dbClusterSnapshotIdentifier: scala.Option[String] = None,
    dbClusterIdentifier: scala.Option[String] = None,
    snapshotCreateTime: scala.Option[TStamp] = None,
    engine: scala.Option[String] = None,
    engineMode: scala.Option[String] = None,
    allocatedStorage: scala.Option[Integer] = None,
    status: scala.Option[String] = None,
    port: scala.Option[Integer] = None,
    vpcId: scala.Option[String] = None,
    clusterCreateTime: scala.Option[TStamp] = None,
    masterUsername: scala.Option[String] = None,
    engineVersion: scala.Option[String] = None,
    licenseModel: scala.Option[String] = None,
    snapshotType: scala.Option[String] = None,
    percentProgress: scala.Option[Integer] = None,
    storageEncrypted: scala.Option[Boolean] = None,
    kmsKeyId: scala.Option[String] = None,
    dbClusterSnapshotArn: scala.Option[String] = None,
    sourceDBClusterSnapshotArn: scala.Option[String] = None,
    iamDatabaseAuthenticationEnabled: scala.Option[Boolean] = None,
    tagList: scala.Option[Iterable[zio.aws.rds.model.Tag]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.DBClusterSnapshot = {
    import DBClusterSnapshot.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.DBClusterSnapshot
      .builder()
      .optionallyWith(
        availabilityZones.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.availabilityZones)
      .optionallyWith(
        dbClusterSnapshotIdentifier.map(value => value: java.lang.String)
      )(_.dbClusterSnapshotIdentifier)
      .optionallyWith(
        dbClusterIdentifier.map(value => value: java.lang.String)
      )(_.dbClusterIdentifier)
      .optionallyWith(
        snapshotCreateTime.map(value => TStamp.unwrap(value): Instant)
      )(_.snapshotCreateTime)
      .optionallyWith(engine.map(value => value: java.lang.String))(_.engine)
      .optionallyWith(engineMode.map(value => value: java.lang.String))(
        _.engineMode
      )
      .optionallyWith(allocatedStorage.map(value => value: java.lang.Integer))(
        _.allocatedStorage
      )
      .optionallyWith(status.map(value => value: java.lang.String))(_.status)
      .optionallyWith(port.map(value => value: java.lang.Integer))(_.port)
      .optionallyWith(vpcId.map(value => value: java.lang.String))(_.vpcId)
      .optionallyWith(
        clusterCreateTime.map(value => TStamp.unwrap(value): Instant)
      )(_.clusterCreateTime)
      .optionallyWith(masterUsername.map(value => value: java.lang.String))(
        _.masterUsername
      )
      .optionallyWith(engineVersion.map(value => value: java.lang.String))(
        _.engineVersion
      )
      .optionallyWith(licenseModel.map(value => value: java.lang.String))(
        _.licenseModel
      )
      .optionallyWith(snapshotType.map(value => value: java.lang.String))(
        _.snapshotType
      )
      .optionallyWith(percentProgress.map(value => value: java.lang.Integer))(
        _.percentProgress
      )
      .optionallyWith(storageEncrypted.map(value => value: java.lang.Boolean))(
        _.storageEncrypted
      )
      .optionallyWith(kmsKeyId.map(value => value: java.lang.String))(
        _.kmsKeyId
      )
      .optionallyWith(
        dbClusterSnapshotArn.map(value => value: java.lang.String)
      )(_.dbClusterSnapshotArn)
      .optionallyWith(
        sourceDBClusterSnapshotArn.map(value => value: java.lang.String)
      )(_.sourceDBClusterSnapshotArn)
      .optionallyWith(
        iamDatabaseAuthenticationEnabled.map(value => value: java.lang.Boolean)
      )(_.iamDatabaseAuthenticationEnabled)
      .optionallyWith(
        tagList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tagList)
      .build()
  }
  def asReadOnly: zio.aws.rds.model.DBClusterSnapshot.ReadOnly =
    zio.aws.rds.model.DBClusterSnapshot.wrap(buildAwsValue())
}
object DBClusterSnapshot {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.DBClusterSnapshot
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.DBClusterSnapshot =
      zio.aws.rds.model.DBClusterSnapshot(
        availabilityZones.map(value => value),
        dbClusterSnapshotIdentifier.map(value => value),
        dbClusterIdentifier.map(value => value),
        snapshotCreateTime.map(value => value),
        engine.map(value => value),
        engineMode.map(value => value),
        allocatedStorage.map(value => value),
        status.map(value => value),
        port.map(value => value),
        vpcId.map(value => value),
        clusterCreateTime.map(value => value),
        masterUsername.map(value => value),
        engineVersion.map(value => value),
        licenseModel.map(value => value),
        snapshotType.map(value => value),
        percentProgress.map(value => value),
        storageEncrypted.map(value => value),
        kmsKeyId.map(value => value),
        dbClusterSnapshotArn.map(value => value),
        sourceDBClusterSnapshotArn.map(value => value),
        iamDatabaseAuthenticationEnabled.map(value => value),
        tagList.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def availabilityZones: scala.Option[List[String]]
    def dbClusterSnapshotIdentifier: scala.Option[String]
    def dbClusterIdentifier: scala.Option[String]
    def snapshotCreateTime: scala.Option[TStamp]
    def engine: scala.Option[String]
    def engineMode: scala.Option[String]
    def allocatedStorage: scala.Option[Integer]
    def status: scala.Option[String]
    def port: scala.Option[Integer]
    def vpcId: scala.Option[String]
    def clusterCreateTime: scala.Option[TStamp]
    def masterUsername: scala.Option[String]
    def engineVersion: scala.Option[String]
    def licenseModel: scala.Option[String]
    def snapshotType: scala.Option[String]
    def percentProgress: scala.Option[Integer]
    def storageEncrypted: scala.Option[Boolean]
    def kmsKeyId: scala.Option[String]
    def dbClusterSnapshotArn: scala.Option[String]
    def sourceDBClusterSnapshotArn: scala.Option[String]
    def iamDatabaseAuthenticationEnabled: scala.Option[Boolean]
    def tagList: scala.Option[List[zio.aws.rds.model.Tag.ReadOnly]]
    def getAvailabilityZones: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("availabilityZones", availabilityZones)
    def getDbClusterSnapshotIdentifier: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "dbClusterSnapshotIdentifier",
        dbClusterSnapshotIdentifier
      )
    def getDbClusterIdentifier: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("dbClusterIdentifier", dbClusterIdentifier)
    def getSnapshotCreateTime: ZIO[Any, AwsError, TStamp] =
      AwsError.unwrapOptionField("snapshotCreateTime", snapshotCreateTime)
    def getEngine: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("engine", engine)
    def getEngineMode: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("engineMode", engineMode)
    def getAllocatedStorage: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("allocatedStorage", allocatedStorage)
    def getStatus: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("status", status)
    def getPort: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("port", port)
    def getVpcId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("vpcId", vpcId)
    def getClusterCreateTime: ZIO[Any, AwsError, TStamp] =
      AwsError.unwrapOptionField("clusterCreateTime", clusterCreateTime)
    def getMasterUsername: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("masterUsername", masterUsername)
    def getEngineVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("engineVersion", engineVersion)
    def getLicenseModel: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("licenseModel", licenseModel)
    def getSnapshotType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("snapshotType", snapshotType)
    def getPercentProgress: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("percentProgress", percentProgress)
    def getStorageEncrypted: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("storageEncrypted", storageEncrypted)
    def getKmsKeyId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("kmsKeyId", kmsKeyId)
    def getDbClusterSnapshotArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("dbClusterSnapshotArn", dbClusterSnapshotArn)
    def getSourceDBClusterSnapshotArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "sourceDBClusterSnapshotArn",
        sourceDBClusterSnapshotArn
      )
    def getIamDatabaseAuthenticationEnabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField(
        "iamDatabaseAuthenticationEnabled",
        iamDatabaseAuthenticationEnabled
      )
    def getTagList: ZIO[Any, AwsError, List[zio.aws.rds.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tagList", tagList)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.DBClusterSnapshot
  ) extends zio.aws.rds.model.DBClusterSnapshot.ReadOnly {
    override val availabilityZones: scala.Option[List[String]] = scala
      .Option(impl.availabilityZones())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val dbClusterSnapshotIdentifier: scala.Option[String] = scala
      .Option(impl.dbClusterSnapshotIdentifier())
      .map(value => value: String)
    override val dbClusterIdentifier: scala.Option[String] =
      scala.Option(impl.dbClusterIdentifier()).map(value => value: String)
    override val snapshotCreateTime: scala.Option[TStamp] = scala
      .Option(impl.snapshotCreateTime())
      .map(value => zio.aws.rds.model.primitives.TStamp(value))
    override val engine: scala.Option[String] =
      scala.Option(impl.engine()).map(value => value: String)
    override val engineMode: scala.Option[String] =
      scala.Option(impl.engineMode()).map(value => value: String)
    override val allocatedStorage: scala.Option[Integer] =
      scala.Option(impl.allocatedStorage()).map(value => value: Integer)
    override val status: scala.Option[String] =
      scala.Option(impl.status()).map(value => value: String)
    override val port: scala.Option[Integer] =
      scala.Option(impl.port()).map(value => value: Integer)
    override val vpcId: scala.Option[String] =
      scala.Option(impl.vpcId()).map(value => value: String)
    override val clusterCreateTime: scala.Option[TStamp] = scala
      .Option(impl.clusterCreateTime())
      .map(value => zio.aws.rds.model.primitives.TStamp(value))
    override val masterUsername: scala.Option[String] =
      scala.Option(impl.masterUsername()).map(value => value: String)
    override val engineVersion: scala.Option[String] =
      scala.Option(impl.engineVersion()).map(value => value: String)
    override val licenseModel: scala.Option[String] =
      scala.Option(impl.licenseModel()).map(value => value: String)
    override val snapshotType: scala.Option[String] =
      scala.Option(impl.snapshotType()).map(value => value: String)
    override val percentProgress: scala.Option[Integer] =
      scala.Option(impl.percentProgress()).map(value => value: Integer)
    override val storageEncrypted: scala.Option[Boolean] =
      scala.Option(impl.storageEncrypted()).map(value => value: Boolean)
    override val kmsKeyId: scala.Option[String] =
      scala.Option(impl.kmsKeyId()).map(value => value: String)
    override val dbClusterSnapshotArn: scala.Option[String] =
      scala.Option(impl.dbClusterSnapshotArn()).map(value => value: String)
    override val sourceDBClusterSnapshotArn: scala.Option[String] = scala
      .Option(impl.sourceDBClusterSnapshotArn())
      .map(value => value: String)
    override val iamDatabaseAuthenticationEnabled: scala.Option[Boolean] = scala
      .Option(impl.iamDatabaseAuthenticationEnabled())
      .map(value => value: Boolean)
    override val tagList: scala.Option[List[zio.aws.rds.model.Tag.ReadOnly]] =
      scala
        .Option(impl.tagList())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.rds.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.DBClusterSnapshot
  ): zio.aws.rds.model.DBClusterSnapshot.ReadOnly = new Wrapper(impl)
}
