package zio.aws.rds.model
import java.lang.Integer
import zio.aws.rds.model.primitives.IntegerOptional
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DBClusterMember(
    dbInstanceIdentifier: scala.Option[String] = None,
    isClusterWriter: scala.Option[Boolean] = None,
    dbClusterParameterGroupStatus: scala.Option[String] = None,
    promotionTier: scala.Option[IntegerOptional] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.DBClusterMember = {
    import DBClusterMember.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.DBClusterMember
      .builder()
      .optionallyWith(
        dbInstanceIdentifier.map(value => value: java.lang.String)
      )(_.dbInstanceIdentifier)
      .optionallyWith(isClusterWriter.map(value => value: java.lang.Boolean))(
        _.isClusterWriter
      )
      .optionallyWith(
        dbClusterParameterGroupStatus.map(value => value: java.lang.String)
      )(_.dbClusterParameterGroupStatus)
      .optionallyWith(promotionTier.map(value => value: Integer))(
        _.promotionTier
      )
      .build()
  }
  def asReadOnly: zio.aws.rds.model.DBClusterMember.ReadOnly =
    zio.aws.rds.model.DBClusterMember.wrap(buildAwsValue())
}
object DBClusterMember {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.DBClusterMember
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.DBClusterMember =
      zio.aws.rds.model.DBClusterMember(
        dbInstanceIdentifier.map(value => value),
        isClusterWriter.map(value => value),
        dbClusterParameterGroupStatus.map(value => value),
        promotionTier.map(value => value)
      )
    def dbInstanceIdentifier: scala.Option[String]
    def isClusterWriter: scala.Option[Boolean]
    def dbClusterParameterGroupStatus: scala.Option[String]
    def promotionTier: scala.Option[IntegerOptional]
    def getDbInstanceIdentifier: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("dbInstanceIdentifier", dbInstanceIdentifier)
    def getIsClusterWriter: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("isClusterWriter", isClusterWriter)
    def getDbClusterParameterGroupStatus: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "dbClusterParameterGroupStatus",
        dbClusterParameterGroupStatus
      )
    def getPromotionTier: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("promotionTier", promotionTier)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.DBClusterMember
  ) extends zio.aws.rds.model.DBClusterMember.ReadOnly {
    override val dbInstanceIdentifier: scala.Option[String] =
      scala.Option(impl.dbInstanceIdentifier()).map(value => value: String)
    override val isClusterWriter: scala.Option[Boolean] =
      scala.Option(impl.isClusterWriter()).map(value => value: Boolean)
    override val dbClusterParameterGroupStatus: scala.Option[String] = scala
      .Option(impl.dbClusterParameterGroupStatus())
      .map(value => value: String)
    override val promotionTier: scala.Option[IntegerOptional] =
      scala.Option(impl.promotionTier()).map(value => value: IntegerOptional)
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.DBClusterMember
  ): zio.aws.rds.model.DBClusterMember.ReadOnly = new Wrapper(impl)
}
