package zio.aws.rds.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateDbSubnetGroupRequest(
    dbSubnetGroupName: String,
    dbSubnetGroupDescription: String,
    subnetIds: Iterable[String],
    tags: scala.Option[Iterable[zio.aws.rds.model.Tag]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.CreateDbSubnetGroupRequest = {
    import CreateDbSubnetGroupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.CreateDbSubnetGroupRequest
      .builder()
      .dbSubnetGroupName(dbSubnetGroupName: java.lang.String)
      .dbSubnetGroupDescription(dbSubnetGroupDescription: java.lang.String)
      .subnetIds(subnetIds.map { item =>
        item: java.lang.String
      }.asJavaCollection)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.rds.model.CreateDbSubnetGroupRequest.ReadOnly =
    zio.aws.rds.model.CreateDbSubnetGroupRequest.wrap(buildAwsValue())
}
object CreateDbSubnetGroupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.CreateDbSubnetGroupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.CreateDbSubnetGroupRequest =
      zio.aws.rds.model.CreateDbSubnetGroupRequest(
        dbSubnetGroupName,
        dbSubnetGroupDescription,
        subnetIds,
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def dbSubnetGroupName: String
    def dbSubnetGroupDescription: String
    def subnetIds: List[String]
    def tags: scala.Option[List[zio.aws.rds.model.Tag.ReadOnly]]
    def getDbSubnetGroupName: ZIO[Any, Nothing, String] =
      ZIO.succeed(dbSubnetGroupName)
    def getDbSubnetGroupDescription: ZIO[Any, Nothing, String] =
      ZIO.succeed(dbSubnetGroupDescription)
    def getSubnetIds: ZIO[Any, Nothing, List[String]] = ZIO.succeed(subnetIds)
    def getTags: ZIO[Any, AwsError, List[zio.aws.rds.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.CreateDbSubnetGroupRequest
  ) extends zio.aws.rds.model.CreateDbSubnetGroupRequest.ReadOnly {
    override val dbSubnetGroupName: String = impl.dbSubnetGroupName(): String
    override val dbSubnetGroupDescription: String =
      impl.dbSubnetGroupDescription(): String
    override val subnetIds: List[String] = impl
      .subnetIds()
      .asScala
      .map { item =>
        item: String
      }
      .toList
    override val tags: scala.Option[List[zio.aws.rds.model.Tag.ReadOnly]] =
      scala
        .Option(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.rds.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.CreateDbSubnetGroupRequest
  ): zio.aws.rds.model.CreateDbSubnetGroupRequest.ReadOnly = new Wrapper(impl)
}
