package zio.aws.rds.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateDbClusterSnapshotResponse(
    dbClusterSnapshot: scala.Option[zio.aws.rds.model.DBClusterSnapshot] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.CreateDbClusterSnapshotResponse = {
    import CreateDbClusterSnapshotResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.CreateDbClusterSnapshotResponse
      .builder()
      .optionallyWith(dbClusterSnapshot.map(value => value.buildAwsValue()))(
        _.dbClusterSnapshot
      )
      .build()
  }
  def asReadOnly: zio.aws.rds.model.CreateDbClusterSnapshotResponse.ReadOnly =
    zio.aws.rds.model.CreateDbClusterSnapshotResponse.wrap(buildAwsValue())
}
object CreateDbClusterSnapshotResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.CreateDbClusterSnapshotResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.CreateDbClusterSnapshotResponse =
      zio.aws.rds.model.CreateDbClusterSnapshotResponse(
        dbClusterSnapshot.map(value => value.asEditable)
      )
    def dbClusterSnapshot
        : scala.Option[zio.aws.rds.model.DBClusterSnapshot.ReadOnly]
    def getDbClusterSnapshot
        : ZIO[Any, AwsError, zio.aws.rds.model.DBClusterSnapshot.ReadOnly] =
      AwsError.unwrapOptionField("dbClusterSnapshot", dbClusterSnapshot)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.CreateDbClusterSnapshotResponse
  ) extends zio.aws.rds.model.CreateDbClusterSnapshotResponse.ReadOnly {
    override val dbClusterSnapshot
        : scala.Option[zio.aws.rds.model.DBClusterSnapshot.ReadOnly] = scala
      .Option(impl.dbClusterSnapshot())
      .map(value => zio.aws.rds.model.DBClusterSnapshot.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.CreateDbClusterSnapshotResponse
  ): zio.aws.rds.model.CreateDbClusterSnapshotResponse.ReadOnly = new Wrapper(
    impl
  )
}
