package zio.aws.rds.model
import zio.aws.rds.model.primitives.{BooleanOptional, TStamp}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class Certificate(
    certificateIdentifier: scala.Option[String] = None,
    certificateType: scala.Option[String] = None,
    thumbprint: scala.Option[String] = None,
    validFrom: scala.Option[TStamp] = None,
    validTill: scala.Option[TStamp] = None,
    certificateArn: scala.Option[String] = None,
    customerOverride: scala.Option[BooleanOptional] = None,
    customerOverrideValidTill: scala.Option[TStamp] = None
) {
  def buildAwsValue(): software.amazon.awssdk.services.rds.model.Certificate = {
    import Certificate.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.Certificate
      .builder()
      .optionallyWith(
        certificateIdentifier.map(value => value: java.lang.String)
      )(_.certificateIdentifier)
      .optionallyWith(certificateType.map(value => value: java.lang.String))(
        _.certificateType
      )
      .optionallyWith(thumbprint.map(value => value: java.lang.String))(
        _.thumbprint
      )
      .optionallyWith(validFrom.map(value => TStamp.unwrap(value): Instant))(
        _.validFrom
      )
      .optionallyWith(validTill.map(value => TStamp.unwrap(value): Instant))(
        _.validTill
      )
      .optionallyWith(certificateArn.map(value => value: java.lang.String))(
        _.certificateArn
      )
      .optionallyWith(customerOverride.map(value => value: java.lang.Boolean))(
        _.customerOverride
      )
      .optionallyWith(
        customerOverrideValidTill.map(value => TStamp.unwrap(value): Instant)
      )(_.customerOverrideValidTill)
      .build()
  }
  def asReadOnly: zio.aws.rds.model.Certificate.ReadOnly =
    zio.aws.rds.model.Certificate.wrap(buildAwsValue())
}
object Certificate {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.rds.model.Certificate] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.Certificate =
      zio.aws.rds.model.Certificate(
        certificateIdentifier.map(value => value),
        certificateType.map(value => value),
        thumbprint.map(value => value),
        validFrom.map(value => value),
        validTill.map(value => value),
        certificateArn.map(value => value),
        customerOverride.map(value => value),
        customerOverrideValidTill.map(value => value)
      )
    def certificateIdentifier: scala.Option[String]
    def certificateType: scala.Option[String]
    def thumbprint: scala.Option[String]
    def validFrom: scala.Option[TStamp]
    def validTill: scala.Option[TStamp]
    def certificateArn: scala.Option[String]
    def customerOverride: scala.Option[BooleanOptional]
    def customerOverrideValidTill: scala.Option[TStamp]
    def getCertificateIdentifier: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("certificateIdentifier", certificateIdentifier)
    def getCertificateType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("certificateType", certificateType)
    def getThumbprint: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("thumbprint", thumbprint)
    def getValidFrom: ZIO[Any, AwsError, TStamp] =
      AwsError.unwrapOptionField("validFrom", validFrom)
    def getValidTill: ZIO[Any, AwsError, TStamp] =
      AwsError.unwrapOptionField("validTill", validTill)
    def getCertificateArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("certificateArn", certificateArn)
    def getCustomerOverride: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("customerOverride", customerOverride)
    def getCustomerOverrideValidTill: ZIO[Any, AwsError, TStamp] = AwsError
      .unwrapOptionField("customerOverrideValidTill", customerOverrideValidTill)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.Certificate
  ) extends zio.aws.rds.model.Certificate.ReadOnly {
    override val certificateIdentifier: scala.Option[String] =
      scala.Option(impl.certificateIdentifier()).map(value => value: String)
    override val certificateType: scala.Option[String] =
      scala.Option(impl.certificateType()).map(value => value: String)
    override val thumbprint: scala.Option[String] =
      scala.Option(impl.thumbprint()).map(value => value: String)
    override val validFrom: scala.Option[TStamp] = scala
      .Option(impl.validFrom())
      .map(value => zio.aws.rds.model.primitives.TStamp(value))
    override val validTill: scala.Option[TStamp] = scala
      .Option(impl.validTill())
      .map(value => zio.aws.rds.model.primitives.TStamp(value))
    override val certificateArn: scala.Option[String] =
      scala.Option(impl.certificateArn()).map(value => value: String)
    override val customerOverride: scala.Option[BooleanOptional] =
      scala.Option(impl.customerOverride()).map(value => value: BooleanOptional)
    override val customerOverrideValidTill: scala.Option[TStamp] = scala
      .Option(impl.customerOverrideValidTill())
      .map(value => zio.aws.rds.model.primitives.TStamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.Certificate
  ): zio.aws.rds.model.Certificate.ReadOnly = new Wrapper(impl)
}
