package zio.aws.rds.model
import zio.aws.rds.model.primitives.BooleanOptional
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class UpgradeTarget(
    engine: scala.Option[String] = None,
    engineVersion: scala.Option[String] = None,
    description: scala.Option[String] = None,
    autoUpgrade: scala.Option[Boolean] = None,
    isMajorVersionUpgrade: scala.Option[Boolean] = None,
    supportedEngineModes: scala.Option[Iterable[String]] = None,
    supportsParallelQuery: scala.Option[BooleanOptional] = None,
    supportsGlobalDatabases: scala.Option[BooleanOptional] = None,
    supportsBabelfish: scala.Option[BooleanOptional] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.UpgradeTarget = {
    import UpgradeTarget.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.UpgradeTarget
      .builder()
      .optionallyWith(engine.map(value => value: java.lang.String))(_.engine)
      .optionallyWith(engineVersion.map(value => value: java.lang.String))(
        _.engineVersion
      )
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(autoUpgrade.map(value => value: java.lang.Boolean))(
        _.autoUpgrade
      )
      .optionallyWith(
        isMajorVersionUpgrade.map(value => value: java.lang.Boolean)
      )(_.isMajorVersionUpgrade)
      .optionallyWith(
        supportedEngineModes.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.supportedEngineModes)
      .optionallyWith(
        supportsParallelQuery.map(value => value: java.lang.Boolean)
      )(_.supportsParallelQuery)
      .optionallyWith(
        supportsGlobalDatabases.map(value => value: java.lang.Boolean)
      )(_.supportsGlobalDatabases)
      .optionallyWith(supportsBabelfish.map(value => value: java.lang.Boolean))(
        _.supportsBabelfish
      )
      .build()
  }
  def asReadOnly: zio.aws.rds.model.UpgradeTarget.ReadOnly =
    zio.aws.rds.model.UpgradeTarget.wrap(buildAwsValue())
}
object UpgradeTarget {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.rds.model.UpgradeTarget] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.UpgradeTarget =
      zio.aws.rds.model.UpgradeTarget(
        engine.map(value => value),
        engineVersion.map(value => value),
        description.map(value => value),
        autoUpgrade.map(value => value),
        isMajorVersionUpgrade.map(value => value),
        supportedEngineModes.map(value => value),
        supportsParallelQuery.map(value => value),
        supportsGlobalDatabases.map(value => value),
        supportsBabelfish.map(value => value)
      )
    def engine: scala.Option[String]
    def engineVersion: scala.Option[String]
    def description: scala.Option[String]
    def autoUpgrade: scala.Option[Boolean]
    def isMajorVersionUpgrade: scala.Option[Boolean]
    def supportedEngineModes: scala.Option[List[String]]
    def supportsParallelQuery: scala.Option[BooleanOptional]
    def supportsGlobalDatabases: scala.Option[BooleanOptional]
    def supportsBabelfish: scala.Option[BooleanOptional]
    def getEngine: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("engine", engine)
    def getEngineVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("engineVersion", engineVersion)
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getAutoUpgrade: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("autoUpgrade", autoUpgrade)
    def getIsMajorVersionUpgrade: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("isMajorVersionUpgrade", isMajorVersionUpgrade)
    def getSupportedEngineModes: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("supportedEngineModes", supportedEngineModes)
    def getSupportsParallelQuery: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("supportsParallelQuery", supportsParallelQuery)
    def getSupportsGlobalDatabases: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField(
        "supportsGlobalDatabases",
        supportsGlobalDatabases
      )
    def getSupportsBabelfish: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("supportsBabelfish", supportsBabelfish)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.UpgradeTarget
  ) extends zio.aws.rds.model.UpgradeTarget.ReadOnly {
    override val engine: scala.Option[String] =
      scala.Option(impl.engine()).map(value => value: String)
    override val engineVersion: scala.Option[String] =
      scala.Option(impl.engineVersion()).map(value => value: String)
    override val description: scala.Option[String] =
      scala.Option(impl.description()).map(value => value: String)
    override val autoUpgrade: scala.Option[Boolean] =
      scala.Option(impl.autoUpgrade()).map(value => value: Boolean)
    override val isMajorVersionUpgrade: scala.Option[Boolean] =
      scala.Option(impl.isMajorVersionUpgrade()).map(value => value: Boolean)
    override val supportedEngineModes: scala.Option[List[String]] = scala
      .Option(impl.supportedEngineModes())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val supportsParallelQuery: scala.Option[BooleanOptional] = scala
      .Option(impl.supportsParallelQuery())
      .map(value => value: BooleanOptional)
    override val supportsGlobalDatabases: scala.Option[BooleanOptional] = scala
      .Option(impl.supportsGlobalDatabases())
      .map(value => value: BooleanOptional)
    override val supportsBabelfish: scala.Option[BooleanOptional] = scala
      .Option(impl.supportsBabelfish())
      .map(value => value: BooleanOptional)
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.UpgradeTarget
  ): zio.aws.rds.model.UpgradeTarget.ReadOnly = new Wrapper(impl)
}
