package zio.aws.rds.model
import zio.aws.rds.model.primitives.BooleanOptional
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class StopActivityStreamRequest(
    resourceArn: String,
    applyImmediately: scala.Option[BooleanOptional] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.StopActivityStreamRequest = {
    import StopActivityStreamRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.StopActivityStreamRequest
      .builder()
      .resourceArn(resourceArn: java.lang.String)
      .optionallyWith(applyImmediately.map(value => value: java.lang.Boolean))(
        _.applyImmediately
      )
      .build()
  }
  def asReadOnly: zio.aws.rds.model.StopActivityStreamRequest.ReadOnly =
    zio.aws.rds.model.StopActivityStreamRequest.wrap(buildAwsValue())
}
object StopActivityStreamRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.StopActivityStreamRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.StopActivityStreamRequest =
      zio.aws.rds.model.StopActivityStreamRequest(
        resourceArn,
        applyImmediately.map(value => value)
      )
    def resourceArn: String
    def applyImmediately: scala.Option[BooleanOptional]
    def getResourceArn: ZIO[Any, Nothing, String] = ZIO.succeed(resourceArn)
    def getApplyImmediately: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("applyImmediately", applyImmediately)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.StopActivityStreamRequest
  ) extends zio.aws.rds.model.StopActivityStreamRequest.ReadOnly {
    override val resourceArn: String = impl.resourceArn(): String
    override val applyImmediately: scala.Option[BooleanOptional] =
      scala.Option(impl.applyImmediately()).map(value => value: BooleanOptional)
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.StopActivityStreamRequest
  ): zio.aws.rds.model.StopActivityStreamRequest.ReadOnly = new Wrapper(impl)
}
