package zio.aws.rds.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ResourcePendingMaintenanceActions(
    resourceIdentifier: scala.Option[String] = None,
    pendingMaintenanceActionDetails: scala.Option[Iterable[
      zio.aws.rds.model.PendingMaintenanceAction
    ]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.ResourcePendingMaintenanceActions = {
    import ResourcePendingMaintenanceActions.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.ResourcePendingMaintenanceActions
      .builder()
      .optionallyWith(resourceIdentifier.map(value => value: java.lang.String))(
        _.resourceIdentifier
      )
      .optionallyWith(
        pendingMaintenanceActionDetails.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.pendingMaintenanceActionDetails)
      .build()
  }
  def asReadOnly: zio.aws.rds.model.ResourcePendingMaintenanceActions.ReadOnly =
    zio.aws.rds.model.ResourcePendingMaintenanceActions.wrap(buildAwsValue())
}
object ResourcePendingMaintenanceActions {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.ResourcePendingMaintenanceActions
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.ResourcePendingMaintenanceActions =
      zio.aws.rds.model.ResourcePendingMaintenanceActions(
        resourceIdentifier.map(value => value),
        pendingMaintenanceActionDetails.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def resourceIdentifier: scala.Option[String]
    def pendingMaintenanceActionDetails: scala.Option[List[
      zio.aws.rds.model.PendingMaintenanceAction.ReadOnly
    ]]
    def getResourceIdentifier: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("resourceIdentifier", resourceIdentifier)
    def getPendingMaintenanceActionDetails: ZIO[Any, AwsError, List[
      zio.aws.rds.model.PendingMaintenanceAction.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "pendingMaintenanceActionDetails",
      pendingMaintenanceActionDetails
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.ResourcePendingMaintenanceActions
  ) extends zio.aws.rds.model.ResourcePendingMaintenanceActions.ReadOnly {
    override val resourceIdentifier: scala.Option[String] =
      scala.Option(impl.resourceIdentifier()).map(value => value: String)
    override val pendingMaintenanceActionDetails: scala.Option[List[
      zio.aws.rds.model.PendingMaintenanceAction.ReadOnly
    ]] = scala
      .Option(impl.pendingMaintenanceActionDetails())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.rds.model.PendingMaintenanceAction.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.ResourcePendingMaintenanceActions
  ): zio.aws.rds.model.ResourcePendingMaintenanceActions.ReadOnly = new Wrapper(
    impl
  )
}
