package zio.aws.rds.model
import zio.aws.rds.model.primitives.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ReservedDBInstancesOffering(
    reservedDBInstancesOfferingId: scala.Option[String] = None,
    dbInstanceClass: scala.Option[String] = None,
    duration: scala.Option[Integer] = None,
    fixedPrice: scala.Option[Double] = None,
    usagePrice: scala.Option[Double] = None,
    currencyCode: scala.Option[String] = None,
    productDescription: scala.Option[String] = None,
    offeringType: scala.Option[String] = None,
    multiAZ: scala.Option[Boolean] = None,
    recurringCharges: scala.Option[Iterable[
      zio.aws.rds.model.RecurringCharge
    ]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.ReservedDBInstancesOffering = {
    import ReservedDBInstancesOffering.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.ReservedDBInstancesOffering
      .builder()
      .optionallyWith(
        reservedDBInstancesOfferingId.map(value => value: java.lang.String)
      )(_.reservedDBInstancesOfferingId)
      .optionallyWith(dbInstanceClass.map(value => value: java.lang.String))(
        _.dbInstanceClass
      )
      .optionallyWith(duration.map(value => value: java.lang.Integer))(
        _.duration
      )
      .optionallyWith(fixedPrice.map(value => value: java.lang.Double))(
        _.fixedPrice
      )
      .optionallyWith(usagePrice.map(value => value: java.lang.Double))(
        _.usagePrice
      )
      .optionallyWith(currencyCode.map(value => value: java.lang.String))(
        _.currencyCode
      )
      .optionallyWith(productDescription.map(value => value: java.lang.String))(
        _.productDescription
      )
      .optionallyWith(offeringType.map(value => value: java.lang.String))(
        _.offeringType
      )
      .optionallyWith(multiAZ.map(value => value: java.lang.Boolean))(_.multiAZ)
      .optionallyWith(
        recurringCharges.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.recurringCharges)
      .build()
  }
  def asReadOnly: zio.aws.rds.model.ReservedDBInstancesOffering.ReadOnly =
    zio.aws.rds.model.ReservedDBInstancesOffering.wrap(buildAwsValue())
}
object ReservedDBInstancesOffering {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.ReservedDBInstancesOffering
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.ReservedDBInstancesOffering =
      zio.aws.rds.model.ReservedDBInstancesOffering(
        reservedDBInstancesOfferingId.map(value => value),
        dbInstanceClass.map(value => value),
        duration.map(value => value),
        fixedPrice.map(value => value),
        usagePrice.map(value => value),
        currencyCode.map(value => value),
        productDescription.map(value => value),
        offeringType.map(value => value),
        multiAZ.map(value => value),
        recurringCharges.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def reservedDBInstancesOfferingId: scala.Option[String]
    def dbInstanceClass: scala.Option[String]
    def duration: scala.Option[Integer]
    def fixedPrice: scala.Option[Double]
    def usagePrice: scala.Option[Double]
    def currencyCode: scala.Option[String]
    def productDescription: scala.Option[String]
    def offeringType: scala.Option[String]
    def multiAZ: scala.Option[Boolean]
    def recurringCharges
        : scala.Option[List[zio.aws.rds.model.RecurringCharge.ReadOnly]]
    def getReservedDBInstancesOfferingId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "reservedDBInstancesOfferingId",
        reservedDBInstancesOfferingId
      )
    def getDbInstanceClass: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("dbInstanceClass", dbInstanceClass)
    def getDuration: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("duration", duration)
    def getFixedPrice: ZIO[Any, AwsError, Double] =
      AwsError.unwrapOptionField("fixedPrice", fixedPrice)
    def getUsagePrice: ZIO[Any, AwsError, Double] =
      AwsError.unwrapOptionField("usagePrice", usagePrice)
    def getCurrencyCode: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("currencyCode", currencyCode)
    def getProductDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("productDescription", productDescription)
    def getOfferingType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("offeringType", offeringType)
    def getMultiAZ: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("multiAZ", multiAZ)
    def getRecurringCharges
        : ZIO[Any, AwsError, List[zio.aws.rds.model.RecurringCharge.ReadOnly]] =
      AwsError.unwrapOptionField("recurringCharges", recurringCharges)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.ReservedDBInstancesOffering
  ) extends zio.aws.rds.model.ReservedDBInstancesOffering.ReadOnly {
    override val reservedDBInstancesOfferingId: scala.Option[String] = scala
      .Option(impl.reservedDBInstancesOfferingId())
      .map(value => value: String)
    override val dbInstanceClass: scala.Option[String] =
      scala.Option(impl.dbInstanceClass()).map(value => value: String)
    override val duration: scala.Option[Integer] =
      scala.Option(impl.duration()).map(value => value: Integer)
    override val fixedPrice: scala.Option[Double] =
      scala.Option(impl.fixedPrice()).map(value => value: Double)
    override val usagePrice: scala.Option[Double] =
      scala.Option(impl.usagePrice()).map(value => value: Double)
    override val currencyCode: scala.Option[String] =
      scala.Option(impl.currencyCode()).map(value => value: String)
    override val productDescription: scala.Option[String] =
      scala.Option(impl.productDescription()).map(value => value: String)
    override val offeringType: scala.Option[String] =
      scala.Option(impl.offeringType()).map(value => value: String)
    override val multiAZ: scala.Option[Boolean] =
      scala.Option(impl.multiAZ()).map(value => value: Boolean)
    override val recurringCharges
        : scala.Option[List[zio.aws.rds.model.RecurringCharge.ReadOnly]] = scala
      .Option(impl.recurringCharges())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.rds.model.RecurringCharge.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.ReservedDBInstancesOffering
  ): zio.aws.rds.model.ReservedDBInstancesOffering.ReadOnly = new Wrapper(impl)
}
