package zio.aws.rds.model
import zio.aws.rds.model.primitives.{Integer, TStamp}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class ReservedDBInstance(
    reservedDBInstanceId: scala.Option[String] = None,
    reservedDBInstancesOfferingId: scala.Option[String] = None,
    dbInstanceClass: scala.Option[String] = None,
    startTime: scala.Option[TStamp] = None,
    duration: scala.Option[Integer] = None,
    fixedPrice: scala.Option[Double] = None,
    usagePrice: scala.Option[Double] = None,
    currencyCode: scala.Option[String] = None,
    dbInstanceCount: scala.Option[Integer] = None,
    productDescription: scala.Option[String] = None,
    offeringType: scala.Option[String] = None,
    multiAZ: scala.Option[Boolean] = None,
    state: scala.Option[String] = None,
    recurringCharges: scala.Option[Iterable[
      zio.aws.rds.model.RecurringCharge
    ]] = None,
    reservedDBInstanceArn: scala.Option[String] = None,
    leaseId: scala.Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.ReservedDBInstance = {
    import ReservedDBInstance.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.ReservedDBInstance
      .builder()
      .optionallyWith(
        reservedDBInstanceId.map(value => value: java.lang.String)
      )(_.reservedDBInstanceId)
      .optionallyWith(
        reservedDBInstancesOfferingId.map(value => value: java.lang.String)
      )(_.reservedDBInstancesOfferingId)
      .optionallyWith(dbInstanceClass.map(value => value: java.lang.String))(
        _.dbInstanceClass
      )
      .optionallyWith(startTime.map(value => TStamp.unwrap(value): Instant))(
        _.startTime
      )
      .optionallyWith(duration.map(value => value: java.lang.Integer))(
        _.duration
      )
      .optionallyWith(fixedPrice.map(value => value: java.lang.Double))(
        _.fixedPrice
      )
      .optionallyWith(usagePrice.map(value => value: java.lang.Double))(
        _.usagePrice
      )
      .optionallyWith(currencyCode.map(value => value: java.lang.String))(
        _.currencyCode
      )
      .optionallyWith(dbInstanceCount.map(value => value: java.lang.Integer))(
        _.dbInstanceCount
      )
      .optionallyWith(productDescription.map(value => value: java.lang.String))(
        _.productDescription
      )
      .optionallyWith(offeringType.map(value => value: java.lang.String))(
        _.offeringType
      )
      .optionallyWith(multiAZ.map(value => value: java.lang.Boolean))(_.multiAZ)
      .optionallyWith(state.map(value => value: java.lang.String))(_.state)
      .optionallyWith(
        recurringCharges.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.recurringCharges)
      .optionallyWith(
        reservedDBInstanceArn.map(value => value: java.lang.String)
      )(_.reservedDBInstanceArn)
      .optionallyWith(leaseId.map(value => value: java.lang.String))(_.leaseId)
      .build()
  }
  def asReadOnly: zio.aws.rds.model.ReservedDBInstance.ReadOnly =
    zio.aws.rds.model.ReservedDBInstance.wrap(buildAwsValue())
}
object ReservedDBInstance {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.ReservedDBInstance
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.ReservedDBInstance =
      zio.aws.rds.model.ReservedDBInstance(
        reservedDBInstanceId.map(value => value),
        reservedDBInstancesOfferingId.map(value => value),
        dbInstanceClass.map(value => value),
        startTime.map(value => value),
        duration.map(value => value),
        fixedPrice.map(value => value),
        usagePrice.map(value => value),
        currencyCode.map(value => value),
        dbInstanceCount.map(value => value),
        productDescription.map(value => value),
        offeringType.map(value => value),
        multiAZ.map(value => value),
        state.map(value => value),
        recurringCharges.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        reservedDBInstanceArn.map(value => value),
        leaseId.map(value => value)
      )
    def reservedDBInstanceId: scala.Option[String]
    def reservedDBInstancesOfferingId: scala.Option[String]
    def dbInstanceClass: scala.Option[String]
    def startTime: scala.Option[TStamp]
    def duration: scala.Option[Integer]
    def fixedPrice: scala.Option[Double]
    def usagePrice: scala.Option[Double]
    def currencyCode: scala.Option[String]
    def dbInstanceCount: scala.Option[Integer]
    def productDescription: scala.Option[String]
    def offeringType: scala.Option[String]
    def multiAZ: scala.Option[Boolean]
    def state: scala.Option[String]
    def recurringCharges
        : scala.Option[List[zio.aws.rds.model.RecurringCharge.ReadOnly]]
    def reservedDBInstanceArn: scala.Option[String]
    def leaseId: scala.Option[String]
    def getReservedDBInstanceId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("reservedDBInstanceId", reservedDBInstanceId)
    def getReservedDBInstancesOfferingId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "reservedDBInstancesOfferingId",
        reservedDBInstancesOfferingId
      )
    def getDbInstanceClass: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("dbInstanceClass", dbInstanceClass)
    def getStartTime: ZIO[Any, AwsError, TStamp] =
      AwsError.unwrapOptionField("startTime", startTime)
    def getDuration: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("duration", duration)
    def getFixedPrice: ZIO[Any, AwsError, Double] =
      AwsError.unwrapOptionField("fixedPrice", fixedPrice)
    def getUsagePrice: ZIO[Any, AwsError, Double] =
      AwsError.unwrapOptionField("usagePrice", usagePrice)
    def getCurrencyCode: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("currencyCode", currencyCode)
    def getDbInstanceCount: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("dbInstanceCount", dbInstanceCount)
    def getProductDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("productDescription", productDescription)
    def getOfferingType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("offeringType", offeringType)
    def getMultiAZ: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("multiAZ", multiAZ)
    def getState: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("state", state)
    def getRecurringCharges
        : ZIO[Any, AwsError, List[zio.aws.rds.model.RecurringCharge.ReadOnly]] =
      AwsError.unwrapOptionField("recurringCharges", recurringCharges)
    def getReservedDBInstanceArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("reservedDBInstanceArn", reservedDBInstanceArn)
    def getLeaseId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("leaseId", leaseId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.ReservedDBInstance
  ) extends zio.aws.rds.model.ReservedDBInstance.ReadOnly {
    override val reservedDBInstanceId: scala.Option[String] =
      scala.Option(impl.reservedDBInstanceId()).map(value => value: String)
    override val reservedDBInstancesOfferingId: scala.Option[String] = scala
      .Option(impl.reservedDBInstancesOfferingId())
      .map(value => value: String)
    override val dbInstanceClass: scala.Option[String] =
      scala.Option(impl.dbInstanceClass()).map(value => value: String)
    override val startTime: scala.Option[TStamp] = scala
      .Option(impl.startTime())
      .map(value => zio.aws.rds.model.primitives.TStamp(value))
    override val duration: scala.Option[Integer] =
      scala.Option(impl.duration()).map(value => value: Integer)
    override val fixedPrice: scala.Option[Double] =
      scala.Option(impl.fixedPrice()).map(value => value: Double)
    override val usagePrice: scala.Option[Double] =
      scala.Option(impl.usagePrice()).map(value => value: Double)
    override val currencyCode: scala.Option[String] =
      scala.Option(impl.currencyCode()).map(value => value: String)
    override val dbInstanceCount: scala.Option[Integer] =
      scala.Option(impl.dbInstanceCount()).map(value => value: Integer)
    override val productDescription: scala.Option[String] =
      scala.Option(impl.productDescription()).map(value => value: String)
    override val offeringType: scala.Option[String] =
      scala.Option(impl.offeringType()).map(value => value: String)
    override val multiAZ: scala.Option[Boolean] =
      scala.Option(impl.multiAZ()).map(value => value: Boolean)
    override val state: scala.Option[String] =
      scala.Option(impl.state()).map(value => value: String)
    override val recurringCharges
        : scala.Option[List[zio.aws.rds.model.RecurringCharge.ReadOnly]] = scala
      .Option(impl.recurringCharges())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.rds.model.RecurringCharge.wrap(item)
        }.toList
      )
    override val reservedDBInstanceArn: scala.Option[String] =
      scala.Option(impl.reservedDBInstanceArn()).map(value => value: String)
    override val leaseId: scala.Option[String] =
      scala.Option(impl.leaseId()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.ReservedDBInstance
  ): zio.aws.rds.model.ReservedDBInstance.ReadOnly = new Wrapper(impl)
}
