package zio.aws.rds.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class RemoveFromGlobalClusterResponse(
    globalCluster: scala.Option[zio.aws.rds.model.GlobalCluster] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.RemoveFromGlobalClusterResponse = {
    import RemoveFromGlobalClusterResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.RemoveFromGlobalClusterResponse
      .builder()
      .optionallyWith(globalCluster.map(value => value.buildAwsValue()))(
        _.globalCluster
      )
      .build()
  }
  def asReadOnly: zio.aws.rds.model.RemoveFromGlobalClusterResponse.ReadOnly =
    zio.aws.rds.model.RemoveFromGlobalClusterResponse.wrap(buildAwsValue())
}
object RemoveFromGlobalClusterResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.RemoveFromGlobalClusterResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.RemoveFromGlobalClusterResponse =
      zio.aws.rds.model.RemoveFromGlobalClusterResponse(
        globalCluster.map(value => value.asEditable)
      )
    def globalCluster: scala.Option[zio.aws.rds.model.GlobalCluster.ReadOnly]
    def getGlobalCluster
        : ZIO[Any, AwsError, zio.aws.rds.model.GlobalCluster.ReadOnly] =
      AwsError.unwrapOptionField("globalCluster", globalCluster)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.RemoveFromGlobalClusterResponse
  ) extends zio.aws.rds.model.RemoveFromGlobalClusterResponse.ReadOnly {
    override val globalCluster
        : scala.Option[zio.aws.rds.model.GlobalCluster.ReadOnly] = scala
      .Option(impl.globalCluster())
      .map(value => zio.aws.rds.model.GlobalCluster.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.RemoveFromGlobalClusterResponse
  ): zio.aws.rds.model.RemoveFromGlobalClusterResponse.ReadOnly = new Wrapper(
    impl
  )
}
