package zio.aws.rds.model
import java.lang.Integer
import zio.aws.rds.model.primitives.IntegerOptional
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class PurchaseReservedDbInstancesOfferingRequest(
    reservedDBInstancesOfferingId: String,
    reservedDBInstanceId: scala.Option[String] = None,
    dbInstanceCount: scala.Option[IntegerOptional] = None,
    tags: scala.Option[Iterable[zio.aws.rds.model.Tag]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.PurchaseReservedDbInstancesOfferingRequest = {
    import PurchaseReservedDbInstancesOfferingRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.PurchaseReservedDbInstancesOfferingRequest
      .builder()
      .reservedDBInstancesOfferingId(
        reservedDBInstancesOfferingId: java.lang.String
      )
      .optionallyWith(
        reservedDBInstanceId.map(value => value: java.lang.String)
      )(_.reservedDBInstanceId)
      .optionallyWith(dbInstanceCount.map(value => value: Integer))(
        _.dbInstanceCount
      )
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : zio.aws.rds.model.PurchaseReservedDbInstancesOfferingRequest.ReadOnly =
    zio.aws.rds.model.PurchaseReservedDbInstancesOfferingRequest
      .wrap(buildAwsValue())
}
object PurchaseReservedDbInstancesOfferingRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.PurchaseReservedDbInstancesOfferingRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.rds.model.PurchaseReservedDbInstancesOfferingRequest =
      zio.aws.rds.model.PurchaseReservedDbInstancesOfferingRequest(
        reservedDBInstancesOfferingId,
        reservedDBInstanceId.map(value => value),
        dbInstanceCount.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def reservedDBInstancesOfferingId: String
    def reservedDBInstanceId: scala.Option[String]
    def dbInstanceCount: scala.Option[IntegerOptional]
    def tags: scala.Option[List[zio.aws.rds.model.Tag.ReadOnly]]
    def getReservedDBInstancesOfferingId: ZIO[Any, Nothing, String] =
      ZIO.succeed(reservedDBInstancesOfferingId)
    def getReservedDBInstanceId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("reservedDBInstanceId", reservedDBInstanceId)
    def getDbInstanceCount: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("dbInstanceCount", dbInstanceCount)
    def getTags: ZIO[Any, AwsError, List[zio.aws.rds.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.PurchaseReservedDbInstancesOfferingRequest
  ) extends zio.aws.rds.model.PurchaseReservedDbInstancesOfferingRequest.ReadOnly {
    override val reservedDBInstancesOfferingId: String =
      impl.reservedDBInstancesOfferingId(): String
    override val reservedDBInstanceId: scala.Option[String] =
      scala.Option(impl.reservedDBInstanceId()).map(value => value: String)
    override val dbInstanceCount: scala.Option[IntegerOptional] =
      scala.Option(impl.dbInstanceCount()).map(value => value: IntegerOptional)
    override val tags: scala.Option[List[zio.aws.rds.model.Tag.ReadOnly]] =
      scala
        .Option(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.rds.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.PurchaseReservedDbInstancesOfferingRequest
  ): zio.aws.rds.model.PurchaseReservedDbInstancesOfferingRequest.ReadOnly =
    new Wrapper(impl)
}
