package zio.aws.rds.model
import java.lang.Integer
import zio.aws.rds.model.primitives.IntegerOptional
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ModifyCurrentDbClusterCapacityResponse(
    dbClusterIdentifier: scala.Option[String] = None,
    pendingCapacity: scala.Option[IntegerOptional] = None,
    currentCapacity: scala.Option[IntegerOptional] = None,
    secondsBeforeTimeout: scala.Option[IntegerOptional] = None,
    timeoutAction: scala.Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.ModifyCurrentDbClusterCapacityResponse = {
    import ModifyCurrentDbClusterCapacityResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.ModifyCurrentDbClusterCapacityResponse
      .builder()
      .optionallyWith(
        dbClusterIdentifier.map(value => value: java.lang.String)
      )(_.dbClusterIdentifier)
      .optionallyWith(pendingCapacity.map(value => value: Integer))(
        _.pendingCapacity
      )
      .optionallyWith(currentCapacity.map(value => value: Integer))(
        _.currentCapacity
      )
      .optionallyWith(secondsBeforeTimeout.map(value => value: Integer))(
        _.secondsBeforeTimeout
      )
      .optionallyWith(timeoutAction.map(value => value: java.lang.String))(
        _.timeoutAction
      )
      .build()
  }
  def asReadOnly
      : zio.aws.rds.model.ModifyCurrentDbClusterCapacityResponse.ReadOnly =
    zio.aws.rds.model.ModifyCurrentDbClusterCapacityResponse
      .wrap(buildAwsValue())
}
object ModifyCurrentDbClusterCapacityResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.ModifyCurrentDbClusterCapacityResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.ModifyCurrentDbClusterCapacityResponse =
      zio.aws.rds.model.ModifyCurrentDbClusterCapacityResponse(
        dbClusterIdentifier.map(value => value),
        pendingCapacity.map(value => value),
        currentCapacity.map(value => value),
        secondsBeforeTimeout.map(value => value),
        timeoutAction.map(value => value)
      )
    def dbClusterIdentifier: scala.Option[String]
    def pendingCapacity: scala.Option[IntegerOptional]
    def currentCapacity: scala.Option[IntegerOptional]
    def secondsBeforeTimeout: scala.Option[IntegerOptional]
    def timeoutAction: scala.Option[String]
    def getDbClusterIdentifier: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("dbClusterIdentifier", dbClusterIdentifier)
    def getPendingCapacity: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("pendingCapacity", pendingCapacity)
    def getCurrentCapacity: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("currentCapacity", currentCapacity)
    def getSecondsBeforeTimeout: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("secondsBeforeTimeout", secondsBeforeTimeout)
    def getTimeoutAction: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("timeoutAction", timeoutAction)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.ModifyCurrentDbClusterCapacityResponse
  ) extends zio.aws.rds.model.ModifyCurrentDbClusterCapacityResponse.ReadOnly {
    override val dbClusterIdentifier: scala.Option[String] =
      scala.Option(impl.dbClusterIdentifier()).map(value => value: String)
    override val pendingCapacity: scala.Option[IntegerOptional] =
      scala.Option(impl.pendingCapacity()).map(value => value: IntegerOptional)
    override val currentCapacity: scala.Option[IntegerOptional] =
      scala.Option(impl.currentCapacity()).map(value => value: IntegerOptional)
    override val secondsBeforeTimeout: scala.Option[IntegerOptional] = scala
      .Option(impl.secondsBeforeTimeout())
      .map(value => value: IntegerOptional)
    override val timeoutAction: scala.Option[String] =
      scala.Option(impl.timeoutAction()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.ModifyCurrentDbClusterCapacityResponse
  ): zio.aws.rds.model.ModifyCurrentDbClusterCapacityResponse.ReadOnly =
    new Wrapper(impl)
}
