package zio.aws.rds.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeReservedDbInstancesResponse(
    marker: scala.Option[String] = None,
    reservedDBInstances: scala.Option[Iterable[
      zio.aws.rds.model.ReservedDBInstance
    ]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.DescribeReservedDbInstancesResponse = {
    import DescribeReservedDbInstancesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.DescribeReservedDbInstancesResponse
      .builder()
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .optionallyWith(
        reservedDBInstances.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.reservedDBInstances)
      .build()
  }
  def asReadOnly
      : zio.aws.rds.model.DescribeReservedDbInstancesResponse.ReadOnly =
    zio.aws.rds.model.DescribeReservedDbInstancesResponse.wrap(buildAwsValue())
}
object DescribeReservedDbInstancesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.DescribeReservedDbInstancesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.DescribeReservedDbInstancesResponse =
      zio.aws.rds.model.DescribeReservedDbInstancesResponse(
        marker.map(value => value),
        reservedDBInstances.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def marker: scala.Option[String]
    def reservedDBInstances
        : scala.Option[List[zio.aws.rds.model.ReservedDBInstance.ReadOnly]]
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
    def getReservedDBInstances: ZIO[Any, AwsError, List[
      zio.aws.rds.model.ReservedDBInstance.ReadOnly
    ]] = AwsError.unwrapOptionField("reservedDBInstances", reservedDBInstances)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.DescribeReservedDbInstancesResponse
  ) extends zio.aws.rds.model.DescribeReservedDbInstancesResponse.ReadOnly {
    override val marker: scala.Option[String] =
      scala.Option(impl.marker()).map(value => value: String)
    override val reservedDBInstances
        : scala.Option[List[zio.aws.rds.model.ReservedDBInstance.ReadOnly]] =
      scala
        .Option(impl.reservedDBInstances())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.rds.model.ReservedDBInstance.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.DescribeReservedDbInstancesResponse
  ): zio.aws.rds.model.DescribeReservedDbInstancesResponse.ReadOnly =
    new Wrapper(impl)
}
