package zio.aws.rds.model
import java.lang.Integer
import zio.aws.rds.model.primitives.IntegerOptional
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeOptionGroupOptionsRequest(
    engineName: String,
    majorEngineVersion: scala.Option[String] = None,
    filters: scala.Option[Iterable[zio.aws.rds.model.Filter]] = None,
    maxRecords: scala.Option[IntegerOptional] = None,
    marker: scala.Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.DescribeOptionGroupOptionsRequest = {
    import DescribeOptionGroupOptionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.DescribeOptionGroupOptionsRequest
      .builder()
      .engineName(engineName: java.lang.String)
      .optionallyWith(majorEngineVersion.map(value => value: java.lang.String))(
        _.majorEngineVersion
      )
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .optionallyWith(maxRecords.map(value => value: Integer))(_.maxRecords)
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .build()
  }
  def asReadOnly: zio.aws.rds.model.DescribeOptionGroupOptionsRequest.ReadOnly =
    zio.aws.rds.model.DescribeOptionGroupOptionsRequest.wrap(buildAwsValue())
}
object DescribeOptionGroupOptionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.DescribeOptionGroupOptionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.DescribeOptionGroupOptionsRequest =
      zio.aws.rds.model.DescribeOptionGroupOptionsRequest(
        engineName,
        majorEngineVersion.map(value => value),
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        maxRecords.map(value => value),
        marker.map(value => value)
      )
    def engineName: String
    def majorEngineVersion: scala.Option[String]
    def filters: scala.Option[List[zio.aws.rds.model.Filter.ReadOnly]]
    def maxRecords: scala.Option[IntegerOptional]
    def marker: scala.Option[String]
    def getEngineName: ZIO[Any, Nothing, String] = ZIO.succeed(engineName)
    def getMajorEngineVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("majorEngineVersion", majorEngineVersion)
    def getFilters
        : ZIO[Any, AwsError, List[zio.aws.rds.model.Filter.ReadOnly]] =
      AwsError.unwrapOptionField("filters", filters)
    def getMaxRecords: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("maxRecords", maxRecords)
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.DescribeOptionGroupOptionsRequest
  ) extends zio.aws.rds.model.DescribeOptionGroupOptionsRequest.ReadOnly {
    override val engineName: String = impl.engineName(): String
    override val majorEngineVersion: scala.Option[String] =
      scala.Option(impl.majorEngineVersion()).map(value => value: String)
    override val filters
        : scala.Option[List[zio.aws.rds.model.Filter.ReadOnly]] = scala
      .Option(impl.filters())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.rds.model.Filter.wrap(item)
        }.toList
      )
    override val maxRecords: scala.Option[IntegerOptional] =
      scala.Option(impl.maxRecords()).map(value => value: IntegerOptional)
    override val marker: scala.Option[String] =
      scala.Option(impl.marker()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.DescribeOptionGroupOptionsRequest
  ): zio.aws.rds.model.DescribeOptionGroupOptionsRequest.ReadOnly = new Wrapper(
    impl
  )
}
