package zio.aws.rds.model
import java.lang.Integer
import zio.aws.rds.model.primitives.IntegerOptional
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeDbSnapshotsRequest(
    dbInstanceIdentifier: scala.Option[String] = None,
    dbSnapshotIdentifier: scala.Option[String] = None,
    snapshotType: scala.Option[String] = None,
    filters: scala.Option[Iterable[zio.aws.rds.model.Filter]] = None,
    maxRecords: scala.Option[IntegerOptional] = None,
    marker: scala.Option[String] = None,
    includeShared: scala.Option[Boolean] = None,
    includePublic: scala.Option[Boolean] = None,
    dbiResourceId: scala.Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.DescribeDbSnapshotsRequest = {
    import DescribeDbSnapshotsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.DescribeDbSnapshotsRequest
      .builder()
      .optionallyWith(
        dbInstanceIdentifier.map(value => value: java.lang.String)
      )(_.dbInstanceIdentifier)
      .optionallyWith(
        dbSnapshotIdentifier.map(value => value: java.lang.String)
      )(_.dbSnapshotIdentifier)
      .optionallyWith(snapshotType.map(value => value: java.lang.String))(
        _.snapshotType
      )
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .optionallyWith(maxRecords.map(value => value: Integer))(_.maxRecords)
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .optionallyWith(includeShared.map(value => value: java.lang.Boolean))(
        _.includeShared
      )
      .optionallyWith(includePublic.map(value => value: java.lang.Boolean))(
        _.includePublic
      )
      .optionallyWith(dbiResourceId.map(value => value: java.lang.String))(
        _.dbiResourceId
      )
      .build()
  }
  def asReadOnly: zio.aws.rds.model.DescribeDbSnapshotsRequest.ReadOnly =
    zio.aws.rds.model.DescribeDbSnapshotsRequest.wrap(buildAwsValue())
}
object DescribeDbSnapshotsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.DescribeDbSnapshotsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.DescribeDbSnapshotsRequest =
      zio.aws.rds.model.DescribeDbSnapshotsRequest(
        dbInstanceIdentifier.map(value => value),
        dbSnapshotIdentifier.map(value => value),
        snapshotType.map(value => value),
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        maxRecords.map(value => value),
        marker.map(value => value),
        includeShared.map(value => value),
        includePublic.map(value => value),
        dbiResourceId.map(value => value)
      )
    def dbInstanceIdentifier: scala.Option[String]
    def dbSnapshotIdentifier: scala.Option[String]
    def snapshotType: scala.Option[String]
    def filters: scala.Option[List[zio.aws.rds.model.Filter.ReadOnly]]
    def maxRecords: scala.Option[IntegerOptional]
    def marker: scala.Option[String]
    def includeShared: scala.Option[Boolean]
    def includePublic: scala.Option[Boolean]
    def dbiResourceId: scala.Option[String]
    def getDbInstanceIdentifier: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("dbInstanceIdentifier", dbInstanceIdentifier)
    def getDbSnapshotIdentifier: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("dbSnapshotIdentifier", dbSnapshotIdentifier)
    def getSnapshotType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("snapshotType", snapshotType)
    def getFilters
        : ZIO[Any, AwsError, List[zio.aws.rds.model.Filter.ReadOnly]] =
      AwsError.unwrapOptionField("filters", filters)
    def getMaxRecords: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("maxRecords", maxRecords)
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
    def getIncludeShared: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("includeShared", includeShared)
    def getIncludePublic: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("includePublic", includePublic)
    def getDbiResourceId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("dbiResourceId", dbiResourceId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.DescribeDbSnapshotsRequest
  ) extends zio.aws.rds.model.DescribeDbSnapshotsRequest.ReadOnly {
    override val dbInstanceIdentifier: scala.Option[String] =
      scala.Option(impl.dbInstanceIdentifier()).map(value => value: String)
    override val dbSnapshotIdentifier: scala.Option[String] =
      scala.Option(impl.dbSnapshotIdentifier()).map(value => value: String)
    override val snapshotType: scala.Option[String] =
      scala.Option(impl.snapshotType()).map(value => value: String)
    override val filters
        : scala.Option[List[zio.aws.rds.model.Filter.ReadOnly]] = scala
      .Option(impl.filters())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.rds.model.Filter.wrap(item)
        }.toList
      )
    override val maxRecords: scala.Option[IntegerOptional] =
      scala.Option(impl.maxRecords()).map(value => value: IntegerOptional)
    override val marker: scala.Option[String] =
      scala.Option(impl.marker()).map(value => value: String)
    override val includeShared: scala.Option[Boolean] =
      scala.Option(impl.includeShared()).map(value => value: Boolean)
    override val includePublic: scala.Option[Boolean] =
      scala.Option(impl.includePublic()).map(value => value: Boolean)
    override val dbiResourceId: scala.Option[String] =
      scala.Option(impl.dbiResourceId()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.DescribeDbSnapshotsRequest
  ): zio.aws.rds.model.DescribeDbSnapshotsRequest.ReadOnly = new Wrapper(impl)
}
