package zio.aws.rds.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeDbClusterSnapshotsResponse(
    marker: scala.Option[String] = None,
    dbClusterSnapshots: scala.Option[Iterable[
      zio.aws.rds.model.DBClusterSnapshot
    ]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.DescribeDbClusterSnapshotsResponse = {
    import DescribeDbClusterSnapshotsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.DescribeDbClusterSnapshotsResponse
      .builder()
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .optionallyWith(
        dbClusterSnapshots.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.dbClusterSnapshots)
      .build()
  }
  def asReadOnly
      : zio.aws.rds.model.DescribeDbClusterSnapshotsResponse.ReadOnly =
    zio.aws.rds.model.DescribeDbClusterSnapshotsResponse.wrap(buildAwsValue())
}
object DescribeDbClusterSnapshotsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.DescribeDbClusterSnapshotsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.DescribeDbClusterSnapshotsResponse =
      zio.aws.rds.model.DescribeDbClusterSnapshotsResponse(
        marker.map(value => value),
        dbClusterSnapshots.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def marker: scala.Option[String]
    def dbClusterSnapshots
        : scala.Option[List[zio.aws.rds.model.DBClusterSnapshot.ReadOnly]]
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
    def getDbClusterSnapshots: ZIO[Any, AwsError, List[
      zio.aws.rds.model.DBClusterSnapshot.ReadOnly
    ]] = AwsError.unwrapOptionField("dbClusterSnapshots", dbClusterSnapshots)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.DescribeDbClusterSnapshotsResponse
  ) extends zio.aws.rds.model.DescribeDbClusterSnapshotsResponse.ReadOnly {
    override val marker: scala.Option[String] =
      scala.Option(impl.marker()).map(value => value: String)
    override val dbClusterSnapshots
        : scala.Option[List[zio.aws.rds.model.DBClusterSnapshot.ReadOnly]] =
      scala
        .Option(impl.dbClusterSnapshots())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.rds.model.DBClusterSnapshot.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.DescribeDbClusterSnapshotsResponse
  ): zio.aws.rds.model.DescribeDbClusterSnapshotsResponse.ReadOnly =
    new Wrapper(impl)
}
