package zio.aws.rds.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeDbClusterParameterGroupsResponse(
    marker: scala.Option[String] = None,
    dbClusterParameterGroups: scala.Option[Iterable[
      zio.aws.rds.model.DBClusterParameterGroup
    ]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.DescribeDbClusterParameterGroupsResponse = {
    import DescribeDbClusterParameterGroupsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.DescribeDbClusterParameterGroupsResponse
      .builder()
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .optionallyWith(
        dbClusterParameterGroups.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.dbClusterParameterGroups)
      .build()
  }
  def asReadOnly
      : zio.aws.rds.model.DescribeDbClusterParameterGroupsResponse.ReadOnly =
    zio.aws.rds.model.DescribeDbClusterParameterGroupsResponse
      .wrap(buildAwsValue())
}
object DescribeDbClusterParameterGroupsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.DescribeDbClusterParameterGroupsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.DescribeDbClusterParameterGroupsResponse =
      zio.aws.rds.model.DescribeDbClusterParameterGroupsResponse(
        marker.map(value => value),
        dbClusterParameterGroups.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def marker: scala.Option[String]
    def dbClusterParameterGroups
        : scala.Option[List[zio.aws.rds.model.DBClusterParameterGroup.ReadOnly]]
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
    def getDbClusterParameterGroups: ZIO[Any, AwsError, List[
      zio.aws.rds.model.DBClusterParameterGroup.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "dbClusterParameterGroups",
      dbClusterParameterGroups
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.DescribeDbClusterParameterGroupsResponse
  ) extends zio.aws.rds.model.DescribeDbClusterParameterGroupsResponse.ReadOnly {
    override val marker: scala.Option[String] =
      scala.Option(impl.marker()).map(value => value: String)
    override val dbClusterParameterGroups: scala.Option[List[
      zio.aws.rds.model.DBClusterParameterGroup.ReadOnly
    ]] = scala
      .Option(impl.dbClusterParameterGroups())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.rds.model.DBClusterParameterGroup.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.DescribeDbClusterParameterGroupsResponse
  ): zio.aws.rds.model.DescribeDbClusterParameterGroupsResponse.ReadOnly =
    new Wrapper(impl)
}
