package zio.aws.rds.model
import zio.aws.rds.model.primitives.TStamp
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class DBProxyEndpoint(
    dbProxyEndpointName: scala.Option[String] = None,
    dbProxyEndpointArn: scala.Option[String] = None,
    dbProxyName: scala.Option[String] = None,
    status: scala.Option[zio.aws.rds.model.DBProxyEndpointStatus] = None,
    vpcId: scala.Option[String] = None,
    vpcSecurityGroupIds: scala.Option[Iterable[String]] = None,
    vpcSubnetIds: scala.Option[Iterable[String]] = None,
    endpoint: scala.Option[String] = None,
    createdDate: scala.Option[TStamp] = None,
    targetRole: scala.Option[zio.aws.rds.model.DBProxyEndpointTargetRole] =
      None,
    isDefault: scala.Option[Boolean] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.DBProxyEndpoint = {
    import DBProxyEndpoint.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.DBProxyEndpoint
      .builder()
      .optionallyWith(
        dbProxyEndpointName.map(value => value: java.lang.String)
      )(_.dbProxyEndpointName)
      .optionallyWith(dbProxyEndpointArn.map(value => value: java.lang.String))(
        _.dbProxyEndpointArn
      )
      .optionallyWith(dbProxyName.map(value => value: java.lang.String))(
        _.dbProxyName
      )
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(vpcId.map(value => value: java.lang.String))(_.vpcId)
      .optionallyWith(
        vpcSecurityGroupIds.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.vpcSecurityGroupIds)
      .optionallyWith(
        vpcSubnetIds.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.vpcSubnetIds)
      .optionallyWith(endpoint.map(value => value: java.lang.String))(
        _.endpoint
      )
      .optionallyWith(createdDate.map(value => TStamp.unwrap(value): Instant))(
        _.createdDate
      )
      .optionallyWith(targetRole.map(value => value.unwrap))(_.targetRole)
      .optionallyWith(isDefault.map(value => value: java.lang.Boolean))(
        _.isDefault
      )
      .build()
  }
  def asReadOnly: zio.aws.rds.model.DBProxyEndpoint.ReadOnly =
    zio.aws.rds.model.DBProxyEndpoint.wrap(buildAwsValue())
}
object DBProxyEndpoint {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.DBProxyEndpoint
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.DBProxyEndpoint =
      zio.aws.rds.model.DBProxyEndpoint(
        dbProxyEndpointName.map(value => value),
        dbProxyEndpointArn.map(value => value),
        dbProxyName.map(value => value),
        status.map(value => value),
        vpcId.map(value => value),
        vpcSecurityGroupIds.map(value => value),
        vpcSubnetIds.map(value => value),
        endpoint.map(value => value),
        createdDate.map(value => value),
        targetRole.map(value => value),
        isDefault.map(value => value)
      )
    def dbProxyEndpointName: scala.Option[String]
    def dbProxyEndpointArn: scala.Option[String]
    def dbProxyName: scala.Option[String]
    def status: scala.Option[zio.aws.rds.model.DBProxyEndpointStatus]
    def vpcId: scala.Option[String]
    def vpcSecurityGroupIds: scala.Option[List[String]]
    def vpcSubnetIds: scala.Option[List[String]]
    def endpoint: scala.Option[String]
    def createdDate: scala.Option[TStamp]
    def targetRole: scala.Option[zio.aws.rds.model.DBProxyEndpointTargetRole]
    def isDefault: scala.Option[Boolean]
    def getDbProxyEndpointName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("dbProxyEndpointName", dbProxyEndpointName)
    def getDbProxyEndpointArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("dbProxyEndpointArn", dbProxyEndpointArn)
    def getDbProxyName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("dbProxyName", dbProxyName)
    def getStatus: ZIO[Any, AwsError, zio.aws.rds.model.DBProxyEndpointStatus] =
      AwsError.unwrapOptionField("status", status)
    def getVpcId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("vpcId", vpcId)
    def getVpcSecurityGroupIds: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("vpcSecurityGroupIds", vpcSecurityGroupIds)
    def getVpcSubnetIds: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("vpcSubnetIds", vpcSubnetIds)
    def getEndpoint: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("endpoint", endpoint)
    def getCreatedDate: ZIO[Any, AwsError, TStamp] =
      AwsError.unwrapOptionField("createdDate", createdDate)
    def getTargetRole
        : ZIO[Any, AwsError, zio.aws.rds.model.DBProxyEndpointTargetRole] =
      AwsError.unwrapOptionField("targetRole", targetRole)
    def getIsDefault: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("isDefault", isDefault)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.DBProxyEndpoint
  ) extends zio.aws.rds.model.DBProxyEndpoint.ReadOnly {
    override val dbProxyEndpointName: scala.Option[String] =
      scala.Option(impl.dbProxyEndpointName()).map(value => value: String)
    override val dbProxyEndpointArn: scala.Option[String] =
      scala.Option(impl.dbProxyEndpointArn()).map(value => value: String)
    override val dbProxyName: scala.Option[String] =
      scala.Option(impl.dbProxyName()).map(value => value: String)
    override val status: scala.Option[zio.aws.rds.model.DBProxyEndpointStatus] =
      scala
        .Option(impl.status())
        .map(value => zio.aws.rds.model.DBProxyEndpointStatus.wrap(value))
    override val vpcId: scala.Option[String] =
      scala.Option(impl.vpcId()).map(value => value: String)
    override val vpcSecurityGroupIds: scala.Option[List[String]] = scala
      .Option(impl.vpcSecurityGroupIds())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val vpcSubnetIds: scala.Option[List[String]] = scala
      .Option(impl.vpcSubnetIds())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val endpoint: scala.Option[String] =
      scala.Option(impl.endpoint()).map(value => value: String)
    override val createdDate: scala.Option[TStamp] = scala
      .Option(impl.createdDate())
      .map(value => zio.aws.rds.model.primitives.TStamp(value))
    override val targetRole
        : scala.Option[zio.aws.rds.model.DBProxyEndpointTargetRole] = scala
      .Option(impl.targetRole())
      .map(value => zio.aws.rds.model.DBProxyEndpointTargetRole.wrap(value))
    override val isDefault: scala.Option[Boolean] =
      scala.Option(impl.isDefault()).map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.DBProxyEndpoint
  ): zio.aws.rds.model.DBProxyEndpoint.ReadOnly = new Wrapper(impl)
}
