package zio.aws.rds.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateEventSubscriptionResponse(
    eventSubscription: scala.Option[zio.aws.rds.model.EventSubscription] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.CreateEventSubscriptionResponse = {
    import CreateEventSubscriptionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.CreateEventSubscriptionResponse
      .builder()
      .optionallyWith(eventSubscription.map(value => value.buildAwsValue()))(
        _.eventSubscription
      )
      .build()
  }
  def asReadOnly: zio.aws.rds.model.CreateEventSubscriptionResponse.ReadOnly =
    zio.aws.rds.model.CreateEventSubscriptionResponse.wrap(buildAwsValue())
}
object CreateEventSubscriptionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.CreateEventSubscriptionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.CreateEventSubscriptionResponse =
      zio.aws.rds.model.CreateEventSubscriptionResponse(
        eventSubscription.map(value => value.asEditable)
      )
    def eventSubscription
        : scala.Option[zio.aws.rds.model.EventSubscription.ReadOnly]
    def getEventSubscription
        : ZIO[Any, AwsError, zio.aws.rds.model.EventSubscription.ReadOnly] =
      AwsError.unwrapOptionField("eventSubscription", eventSubscription)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.CreateEventSubscriptionResponse
  ) extends zio.aws.rds.model.CreateEventSubscriptionResponse.ReadOnly {
    override val eventSubscription
        : scala.Option[zio.aws.rds.model.EventSubscription.ReadOnly] = scala
      .Option(impl.eventSubscription())
      .map(value => zio.aws.rds.model.EventSubscription.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.CreateEventSubscriptionResponse
  ): zio.aws.rds.model.CreateEventSubscriptionResponse.ReadOnly = new Wrapper(
    impl
  )
}
