package zio.aws.rds.model
import java.lang.Integer
import zio.aws.rds.model.primitives.{
  LongOptional,
  BooleanOptional,
  IntegerOptional
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateDbClusterRequest(
    availabilityZones: scala.Option[Iterable[String]] = None,
    backupRetentionPeriod: scala.Option[IntegerOptional] = None,
    characterSetName: scala.Option[String] = None,
    databaseName: scala.Option[String] = None,
    dbClusterIdentifier: String,
    dbClusterParameterGroupName: scala.Option[String] = None,
    vpcSecurityGroupIds: scala.Option[Iterable[String]] = None,
    dbSubnetGroupName: scala.Option[String] = None,
    engine: String,
    engineVersion: scala.Option[String] = None,
    port: scala.Option[IntegerOptional] = None,
    masterUsername: scala.Option[String] = None,
    masterUserPassword: scala.Option[String] = None,
    optionGroupName: scala.Option[String] = None,
    preferredBackupWindow: scala.Option[String] = None,
    preferredMaintenanceWindow: scala.Option[String] = None,
    replicationSourceIdentifier: scala.Option[String] = None,
    tags: scala.Option[Iterable[zio.aws.rds.model.Tag]] = None,
    storageEncrypted: scala.Option[BooleanOptional] = None,
    kmsKeyId: scala.Option[String] = None,
    preSignedUrl: scala.Option[String] = None,
    enableIAMDatabaseAuthentication: scala.Option[BooleanOptional] = None,
    backtrackWindow: scala.Option[LongOptional] = None,
    enableCloudwatchLogsExports: scala.Option[Iterable[String]] = None,
    engineMode: scala.Option[String] = None,
    scalingConfiguration: scala.Option[zio.aws.rds.model.ScalingConfiguration] =
      None,
    deletionProtection: scala.Option[BooleanOptional] = None,
    globalClusterIdentifier: scala.Option[String] = None,
    enableHttpEndpoint: scala.Option[BooleanOptional] = None,
    copyTagsToSnapshot: scala.Option[BooleanOptional] = None,
    domain: scala.Option[String] = None,
    domainIAMRoleName: scala.Option[String] = None,
    enableGlobalWriteForwarding: scala.Option[BooleanOptional] = None,
    dbClusterInstanceClass: scala.Option[String] = None,
    allocatedStorage: scala.Option[IntegerOptional] = None,
    storageType: scala.Option[String] = None,
    iops: scala.Option[IntegerOptional] = None,
    publiclyAccessible: scala.Option[BooleanOptional] = None,
    autoMinorVersionUpgrade: scala.Option[BooleanOptional] = None,
    monitoringInterval: scala.Option[IntegerOptional] = None,
    monitoringRoleArn: scala.Option[String] = None,
    enablePerformanceInsights: scala.Option[BooleanOptional] = None,
    performanceInsightsKMSKeyId: scala.Option[String] = None,
    performanceInsightsRetentionPeriod: scala.Option[IntegerOptional] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.CreateDbClusterRequest = {
    import CreateDbClusterRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.CreateDbClusterRequest
      .builder()
      .optionallyWith(
        availabilityZones.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.availabilityZones)
      .optionallyWith(backupRetentionPeriod.map(value => value: Integer))(
        _.backupRetentionPeriod
      )
      .optionallyWith(characterSetName.map(value => value: java.lang.String))(
        _.characterSetName
      )
      .optionallyWith(databaseName.map(value => value: java.lang.String))(
        _.databaseName
      )
      .dbClusterIdentifier(dbClusterIdentifier: java.lang.String)
      .optionallyWith(
        dbClusterParameterGroupName.map(value => value: java.lang.String)
      )(_.dbClusterParameterGroupName)
      .optionallyWith(
        vpcSecurityGroupIds.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.vpcSecurityGroupIds)
      .optionallyWith(dbSubnetGroupName.map(value => value: java.lang.String))(
        _.dbSubnetGroupName
      )
      .engine(engine: java.lang.String)
      .optionallyWith(engineVersion.map(value => value: java.lang.String))(
        _.engineVersion
      )
      .optionallyWith(port.map(value => value: Integer))(_.port)
      .optionallyWith(masterUsername.map(value => value: java.lang.String))(
        _.masterUsername
      )
      .optionallyWith(masterUserPassword.map(value => value: java.lang.String))(
        _.masterUserPassword
      )
      .optionallyWith(optionGroupName.map(value => value: java.lang.String))(
        _.optionGroupName
      )
      .optionallyWith(
        preferredBackupWindow.map(value => value: java.lang.String)
      )(_.preferredBackupWindow)
      .optionallyWith(
        preferredMaintenanceWindow.map(value => value: java.lang.String)
      )(_.preferredMaintenanceWindow)
      .optionallyWith(
        replicationSourceIdentifier.map(value => value: java.lang.String)
      )(_.replicationSourceIdentifier)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(storageEncrypted.map(value => value: java.lang.Boolean))(
        _.storageEncrypted
      )
      .optionallyWith(kmsKeyId.map(value => value: java.lang.String))(
        _.kmsKeyId
      )
      .optionallyWith(preSignedUrl.map(value => value: java.lang.String))(
        _.preSignedUrl
      )
      .optionallyWith(
        enableIAMDatabaseAuthentication.map(value => value: java.lang.Boolean)
      )(_.enableIAMDatabaseAuthentication)
      .optionallyWith(backtrackWindow.map(value => value: java.lang.Long))(
        _.backtrackWindow
      )
      .optionallyWith(
        enableCloudwatchLogsExports.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.enableCloudwatchLogsExports)
      .optionallyWith(engineMode.map(value => value: java.lang.String))(
        _.engineMode
      )
      .optionallyWith(scalingConfiguration.map(value => value.buildAwsValue()))(
        _.scalingConfiguration
      )
      .optionallyWith(
        deletionProtection.map(value => value: java.lang.Boolean)
      )(_.deletionProtection)
      .optionallyWith(
        globalClusterIdentifier.map(value => value: java.lang.String)
      )(_.globalClusterIdentifier)
      .optionallyWith(
        enableHttpEndpoint.map(value => value: java.lang.Boolean)
      )(_.enableHttpEndpoint)
      .optionallyWith(
        copyTagsToSnapshot.map(value => value: java.lang.Boolean)
      )(_.copyTagsToSnapshot)
      .optionallyWith(domain.map(value => value: java.lang.String))(_.domain)
      .optionallyWith(domainIAMRoleName.map(value => value: java.lang.String))(
        _.domainIAMRoleName
      )
      .optionallyWith(
        enableGlobalWriteForwarding.map(value => value: java.lang.Boolean)
      )(_.enableGlobalWriteForwarding)
      .optionallyWith(
        dbClusterInstanceClass.map(value => value: java.lang.String)
      )(_.dbClusterInstanceClass)
      .optionallyWith(allocatedStorage.map(value => value: Integer))(
        _.allocatedStorage
      )
      .optionallyWith(storageType.map(value => value: java.lang.String))(
        _.storageType
      )
      .optionallyWith(iops.map(value => value: Integer))(_.iops)
      .optionallyWith(
        publiclyAccessible.map(value => value: java.lang.Boolean)
      )(_.publiclyAccessible)
      .optionallyWith(
        autoMinorVersionUpgrade.map(value => value: java.lang.Boolean)
      )(_.autoMinorVersionUpgrade)
      .optionallyWith(monitoringInterval.map(value => value: Integer))(
        _.monitoringInterval
      )
      .optionallyWith(monitoringRoleArn.map(value => value: java.lang.String))(
        _.monitoringRoleArn
      )
      .optionallyWith(
        enablePerformanceInsights.map(value => value: java.lang.Boolean)
      )(_.enablePerformanceInsights)
      .optionallyWith(
        performanceInsightsKMSKeyId.map(value => value: java.lang.String)
      )(_.performanceInsightsKMSKeyId)
      .optionallyWith(
        performanceInsightsRetentionPeriod.map(value => value: Integer)
      )(_.performanceInsightsRetentionPeriod)
      .build()
  }
  def asReadOnly: zio.aws.rds.model.CreateDbClusterRequest.ReadOnly =
    zio.aws.rds.model.CreateDbClusterRequest.wrap(buildAwsValue())
}
object CreateDbClusterRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.CreateDbClusterRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.CreateDbClusterRequest =
      zio.aws.rds.model.CreateDbClusterRequest(
        availabilityZones.map(value => value),
        backupRetentionPeriod.map(value => value),
        characterSetName.map(value => value),
        databaseName.map(value => value),
        dbClusterIdentifier,
        dbClusterParameterGroupName.map(value => value),
        vpcSecurityGroupIds.map(value => value),
        dbSubnetGroupName.map(value => value),
        engine,
        engineVersion.map(value => value),
        port.map(value => value),
        masterUsername.map(value => value),
        masterUserPassword.map(value => value),
        optionGroupName.map(value => value),
        preferredBackupWindow.map(value => value),
        preferredMaintenanceWindow.map(value => value),
        replicationSourceIdentifier.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        storageEncrypted.map(value => value),
        kmsKeyId.map(value => value),
        preSignedUrl.map(value => value),
        enableIAMDatabaseAuthentication.map(value => value),
        backtrackWindow.map(value => value),
        enableCloudwatchLogsExports.map(value => value),
        engineMode.map(value => value),
        scalingConfiguration.map(value => value.asEditable),
        deletionProtection.map(value => value),
        globalClusterIdentifier.map(value => value),
        enableHttpEndpoint.map(value => value),
        copyTagsToSnapshot.map(value => value),
        domain.map(value => value),
        domainIAMRoleName.map(value => value),
        enableGlobalWriteForwarding.map(value => value),
        dbClusterInstanceClass.map(value => value),
        allocatedStorage.map(value => value),
        storageType.map(value => value),
        iops.map(value => value),
        publiclyAccessible.map(value => value),
        autoMinorVersionUpgrade.map(value => value),
        monitoringInterval.map(value => value),
        monitoringRoleArn.map(value => value),
        enablePerformanceInsights.map(value => value),
        performanceInsightsKMSKeyId.map(value => value),
        performanceInsightsRetentionPeriod.map(value => value)
      )
    def availabilityZones: scala.Option[List[String]]
    def backupRetentionPeriod: scala.Option[IntegerOptional]
    def characterSetName: scala.Option[String]
    def databaseName: scala.Option[String]
    def dbClusterIdentifier: String
    def dbClusterParameterGroupName: scala.Option[String]
    def vpcSecurityGroupIds: scala.Option[List[String]]
    def dbSubnetGroupName: scala.Option[String]
    def engine: String
    def engineVersion: scala.Option[String]
    def port: scala.Option[IntegerOptional]
    def masterUsername: scala.Option[String]
    def masterUserPassword: scala.Option[String]
    def optionGroupName: scala.Option[String]
    def preferredBackupWindow: scala.Option[String]
    def preferredMaintenanceWindow: scala.Option[String]
    def replicationSourceIdentifier: scala.Option[String]
    def tags: scala.Option[List[zio.aws.rds.model.Tag.ReadOnly]]
    def storageEncrypted: scala.Option[BooleanOptional]
    def kmsKeyId: scala.Option[String]
    def preSignedUrl: scala.Option[String]
    def enableIAMDatabaseAuthentication: scala.Option[BooleanOptional]
    def backtrackWindow: scala.Option[LongOptional]
    def enableCloudwatchLogsExports: scala.Option[List[String]]
    def engineMode: scala.Option[String]
    def scalingConfiguration
        : scala.Option[zio.aws.rds.model.ScalingConfiguration.ReadOnly]
    def deletionProtection: scala.Option[BooleanOptional]
    def globalClusterIdentifier: scala.Option[String]
    def enableHttpEndpoint: scala.Option[BooleanOptional]
    def copyTagsToSnapshot: scala.Option[BooleanOptional]
    def domain: scala.Option[String]
    def domainIAMRoleName: scala.Option[String]
    def enableGlobalWriteForwarding: scala.Option[BooleanOptional]
    def dbClusterInstanceClass: scala.Option[String]
    def allocatedStorage: scala.Option[IntegerOptional]
    def storageType: scala.Option[String]
    def iops: scala.Option[IntegerOptional]
    def publiclyAccessible: scala.Option[BooleanOptional]
    def autoMinorVersionUpgrade: scala.Option[BooleanOptional]
    def monitoringInterval: scala.Option[IntegerOptional]
    def monitoringRoleArn: scala.Option[String]
    def enablePerformanceInsights: scala.Option[BooleanOptional]
    def performanceInsightsKMSKeyId: scala.Option[String]
    def performanceInsightsRetentionPeriod: scala.Option[IntegerOptional]
    def getAvailabilityZones: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("availabilityZones", availabilityZones)
    def getBackupRetentionPeriod: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("backupRetentionPeriod", backupRetentionPeriod)
    def getCharacterSetName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("characterSetName", characterSetName)
    def getDatabaseName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("databaseName", databaseName)
    def getDbClusterIdentifier: ZIO[Any, Nothing, String] =
      ZIO.succeed(dbClusterIdentifier)
    def getDbClusterParameterGroupName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "dbClusterParameterGroupName",
        dbClusterParameterGroupName
      )
    def getVpcSecurityGroupIds: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("vpcSecurityGroupIds", vpcSecurityGroupIds)
    def getDbSubnetGroupName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("dbSubnetGroupName", dbSubnetGroupName)
    def getEngine: ZIO[Any, Nothing, String] = ZIO.succeed(engine)
    def getEngineVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("engineVersion", engineVersion)
    def getPort: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("port", port)
    def getMasterUsername: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("masterUsername", masterUsername)
    def getMasterUserPassword: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("masterUserPassword", masterUserPassword)
    def getOptionGroupName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("optionGroupName", optionGroupName)
    def getPreferredBackupWindow: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("preferredBackupWindow", preferredBackupWindow)
    def getPreferredMaintenanceWindow: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "preferredMaintenanceWindow",
        preferredMaintenanceWindow
      )
    def getReplicationSourceIdentifier: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "replicationSourceIdentifier",
        replicationSourceIdentifier
      )
    def getTags: ZIO[Any, AwsError, List[zio.aws.rds.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getStorageEncrypted: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("storageEncrypted", storageEncrypted)
    def getKmsKeyId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("kmsKeyId", kmsKeyId)
    def getPreSignedUrl: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("preSignedUrl", preSignedUrl)
    def getEnableIAMDatabaseAuthentication
        : ZIO[Any, AwsError, BooleanOptional] = AwsError.unwrapOptionField(
      "enableIAMDatabaseAuthentication",
      enableIAMDatabaseAuthentication
    )
    def getBacktrackWindow: ZIO[Any, AwsError, LongOptional] =
      AwsError.unwrapOptionField("backtrackWindow", backtrackWindow)
    def getEnableCloudwatchLogsExports: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField(
        "enableCloudwatchLogsExports",
        enableCloudwatchLogsExports
      )
    def getEngineMode: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("engineMode", engineMode)
    def getScalingConfiguration
        : ZIO[Any, AwsError, zio.aws.rds.model.ScalingConfiguration.ReadOnly] =
      AwsError.unwrapOptionField("scalingConfiguration", scalingConfiguration)
    def getDeletionProtection: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("deletionProtection", deletionProtection)
    def getGlobalClusterIdentifier: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("globalClusterIdentifier", globalClusterIdentifier)
    def getEnableHttpEndpoint: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("enableHttpEndpoint", enableHttpEndpoint)
    def getCopyTagsToSnapshot: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("copyTagsToSnapshot", copyTagsToSnapshot)
    def getDomain: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("domain", domain)
    def getDomainIAMRoleName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("domainIAMRoleName", domainIAMRoleName)
    def getEnableGlobalWriteForwarding: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField(
        "enableGlobalWriteForwarding",
        enableGlobalWriteForwarding
      )
    def getDbClusterInstanceClass: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("dbClusterInstanceClass", dbClusterInstanceClass)
    def getAllocatedStorage: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("allocatedStorage", allocatedStorage)
    def getStorageType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("storageType", storageType)
    def getIops: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("iops", iops)
    def getPubliclyAccessible: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("publiclyAccessible", publiclyAccessible)
    def getAutoMinorVersionUpgrade: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField(
        "autoMinorVersionUpgrade",
        autoMinorVersionUpgrade
      )
    def getMonitoringInterval: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("monitoringInterval", monitoringInterval)
    def getMonitoringRoleArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("monitoringRoleArn", monitoringRoleArn)
    def getEnablePerformanceInsights: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField(
        "enablePerformanceInsights",
        enablePerformanceInsights
      )
    def getPerformanceInsightsKMSKeyId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "performanceInsightsKMSKeyId",
        performanceInsightsKMSKeyId
      )
    def getPerformanceInsightsRetentionPeriod
        : ZIO[Any, AwsError, IntegerOptional] = AwsError.unwrapOptionField(
      "performanceInsightsRetentionPeriod",
      performanceInsightsRetentionPeriod
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.CreateDbClusterRequest
  ) extends zio.aws.rds.model.CreateDbClusterRequest.ReadOnly {
    override val availabilityZones: scala.Option[List[String]] = scala
      .Option(impl.availabilityZones())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val backupRetentionPeriod: scala.Option[IntegerOptional] = scala
      .Option(impl.backupRetentionPeriod())
      .map(value => value: IntegerOptional)
    override val characterSetName: scala.Option[String] =
      scala.Option(impl.characterSetName()).map(value => value: String)
    override val databaseName: scala.Option[String] =
      scala.Option(impl.databaseName()).map(value => value: String)
    override val dbClusterIdentifier: String =
      impl.dbClusterIdentifier(): String
    override val dbClusterParameterGroupName: scala.Option[String] = scala
      .Option(impl.dbClusterParameterGroupName())
      .map(value => value: String)
    override val vpcSecurityGroupIds: scala.Option[List[String]] = scala
      .Option(impl.vpcSecurityGroupIds())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val dbSubnetGroupName: scala.Option[String] =
      scala.Option(impl.dbSubnetGroupName()).map(value => value: String)
    override val engine: String = impl.engine(): String
    override val engineVersion: scala.Option[String] =
      scala.Option(impl.engineVersion()).map(value => value: String)
    override val port: scala.Option[IntegerOptional] =
      scala.Option(impl.port()).map(value => value: IntegerOptional)
    override val masterUsername: scala.Option[String] =
      scala.Option(impl.masterUsername()).map(value => value: String)
    override val masterUserPassword: scala.Option[String] =
      scala.Option(impl.masterUserPassword()).map(value => value: String)
    override val optionGroupName: scala.Option[String] =
      scala.Option(impl.optionGroupName()).map(value => value: String)
    override val preferredBackupWindow: scala.Option[String] =
      scala.Option(impl.preferredBackupWindow()).map(value => value: String)
    override val preferredMaintenanceWindow: scala.Option[String] = scala
      .Option(impl.preferredMaintenanceWindow())
      .map(value => value: String)
    override val replicationSourceIdentifier: scala.Option[String] = scala
      .Option(impl.replicationSourceIdentifier())
      .map(value => value: String)
    override val tags: scala.Option[List[zio.aws.rds.model.Tag.ReadOnly]] =
      scala
        .Option(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.rds.model.Tag.wrap(item)
          }.toList
        )
    override val storageEncrypted: scala.Option[BooleanOptional] =
      scala.Option(impl.storageEncrypted()).map(value => value: BooleanOptional)
    override val kmsKeyId: scala.Option[String] =
      scala.Option(impl.kmsKeyId()).map(value => value: String)
    override val preSignedUrl: scala.Option[String] =
      scala.Option(impl.preSignedUrl()).map(value => value: String)
    override val enableIAMDatabaseAuthentication
        : scala.Option[BooleanOptional] = scala
      .Option(impl.enableIAMDatabaseAuthentication())
      .map(value => value: BooleanOptional)
    override val backtrackWindow: scala.Option[LongOptional] =
      scala.Option(impl.backtrackWindow()).map(value => value: LongOptional)
    override val enableCloudwatchLogsExports: scala.Option[List[String]] = scala
      .Option(impl.enableCloudwatchLogsExports())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val engineMode: scala.Option[String] =
      scala.Option(impl.engineMode()).map(value => value: String)
    override val scalingConfiguration
        : scala.Option[zio.aws.rds.model.ScalingConfiguration.ReadOnly] = scala
      .Option(impl.scalingConfiguration())
      .map(value => zio.aws.rds.model.ScalingConfiguration.wrap(value))
    override val deletionProtection: scala.Option[BooleanOptional] = scala
      .Option(impl.deletionProtection())
      .map(value => value: BooleanOptional)
    override val globalClusterIdentifier: scala.Option[String] =
      scala.Option(impl.globalClusterIdentifier()).map(value => value: String)
    override val enableHttpEndpoint: scala.Option[BooleanOptional] = scala
      .Option(impl.enableHttpEndpoint())
      .map(value => value: BooleanOptional)
    override val copyTagsToSnapshot: scala.Option[BooleanOptional] = scala
      .Option(impl.copyTagsToSnapshot())
      .map(value => value: BooleanOptional)
    override val domain: scala.Option[String] =
      scala.Option(impl.domain()).map(value => value: String)
    override val domainIAMRoleName: scala.Option[String] =
      scala.Option(impl.domainIAMRoleName()).map(value => value: String)
    override val enableGlobalWriteForwarding: scala.Option[BooleanOptional] =
      scala
        .Option(impl.enableGlobalWriteForwarding())
        .map(value => value: BooleanOptional)
    override val dbClusterInstanceClass: scala.Option[String] =
      scala.Option(impl.dbClusterInstanceClass()).map(value => value: String)
    override val allocatedStorage: scala.Option[IntegerOptional] =
      scala.Option(impl.allocatedStorage()).map(value => value: IntegerOptional)
    override val storageType: scala.Option[String] =
      scala.Option(impl.storageType()).map(value => value: String)
    override val iops: scala.Option[IntegerOptional] =
      scala.Option(impl.iops()).map(value => value: IntegerOptional)
    override val publiclyAccessible: scala.Option[BooleanOptional] = scala
      .Option(impl.publiclyAccessible())
      .map(value => value: BooleanOptional)
    override val autoMinorVersionUpgrade: scala.Option[BooleanOptional] = scala
      .Option(impl.autoMinorVersionUpgrade())
      .map(value => value: BooleanOptional)
    override val monitoringInterval: scala.Option[IntegerOptional] = scala
      .Option(impl.monitoringInterval())
      .map(value => value: IntegerOptional)
    override val monitoringRoleArn: scala.Option[String] =
      scala.Option(impl.monitoringRoleArn()).map(value => value: String)
    override val enablePerformanceInsights: scala.Option[BooleanOptional] =
      scala
        .Option(impl.enablePerformanceInsights())
        .map(value => value: BooleanOptional)
    override val performanceInsightsKMSKeyId: scala.Option[String] = scala
      .Option(impl.performanceInsightsKMSKeyId())
      .map(value => value: String)
    override val performanceInsightsRetentionPeriod
        : scala.Option[IntegerOptional] = scala
      .Option(impl.performanceInsightsRetentionPeriod())
      .map(value => value: IntegerOptional)
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.CreateDbClusterRequest
  ): zio.aws.rds.model.CreateDbClusterRequest.ReadOnly = new Wrapper(impl)
}
