package zio.aws.rds.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CopyOptionGroupResponse(
    optionGroup: scala.Option[zio.aws.rds.model.OptionGroup] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.CopyOptionGroupResponse = {
    import CopyOptionGroupResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.CopyOptionGroupResponse
      .builder()
      .optionallyWith(optionGroup.map(value => value.buildAwsValue()))(
        _.optionGroup
      )
      .build()
  }
  def asReadOnly: zio.aws.rds.model.CopyOptionGroupResponse.ReadOnly =
    zio.aws.rds.model.CopyOptionGroupResponse.wrap(buildAwsValue())
}
object CopyOptionGroupResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.CopyOptionGroupResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.CopyOptionGroupResponse =
      zio.aws.rds.model
        .CopyOptionGroupResponse(optionGroup.map(value => value.asEditable))
    def optionGroup: scala.Option[zio.aws.rds.model.OptionGroup.ReadOnly]
    def getOptionGroup
        : ZIO[Any, AwsError, zio.aws.rds.model.OptionGroup.ReadOnly] =
      AwsError.unwrapOptionField("optionGroup", optionGroup)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.CopyOptionGroupResponse
  ) extends zio.aws.rds.model.CopyOptionGroupResponse.ReadOnly {
    override val optionGroup
        : scala.Option[zio.aws.rds.model.OptionGroup.ReadOnly] = scala
      .Option(impl.optionGroup())
      .map(value => zio.aws.rds.model.OptionGroup.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.CopyOptionGroupResponse
  ): zio.aws.rds.model.CopyOptionGroupResponse.ReadOnly = new Wrapper(impl)
}
