package zio.aws.rds.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AddSourceIdentifierToSubscriptionResponse(
    eventSubscription: scala.Option[zio.aws.rds.model.EventSubscription] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.AddSourceIdentifierToSubscriptionResponse = {
    import AddSourceIdentifierToSubscriptionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.AddSourceIdentifierToSubscriptionResponse
      .builder()
      .optionallyWith(eventSubscription.map(value => value.buildAwsValue()))(
        _.eventSubscription
      )
      .build()
  }
  def asReadOnly
      : zio.aws.rds.model.AddSourceIdentifierToSubscriptionResponse.ReadOnly =
    zio.aws.rds.model.AddSourceIdentifierToSubscriptionResponse
      .wrap(buildAwsValue())
}
object AddSourceIdentifierToSubscriptionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.AddSourceIdentifierToSubscriptionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.rds.model.AddSourceIdentifierToSubscriptionResponse =
      zio.aws.rds.model.AddSourceIdentifierToSubscriptionResponse(
        eventSubscription.map(value => value.asEditable)
      )
    def eventSubscription
        : scala.Option[zio.aws.rds.model.EventSubscription.ReadOnly]
    def getEventSubscription
        : ZIO[Any, AwsError, zio.aws.rds.model.EventSubscription.ReadOnly] =
      AwsError.unwrapOptionField("eventSubscription", eventSubscription)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.AddSourceIdentifierToSubscriptionResponse
  ) extends zio.aws.rds.model.AddSourceIdentifierToSubscriptionResponse.ReadOnly {
    override val eventSubscription
        : scala.Option[zio.aws.rds.model.EventSubscription.ReadOnly] = scala
      .Option(impl.eventSubscription())
      .map(value => zio.aws.rds.model.EventSubscription.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.AddSourceIdentifierToSubscriptionResponse
  ): zio.aws.rds.model.AddSourceIdentifierToSubscriptionResponse.ReadOnly =
    new Wrapper(impl)
}
