package zio.aws.rds.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class StopDbInstanceRequest(
    dbInstanceIdentifier: String,
    dbSnapshotIdentifier: scala.Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.StopDbInstanceRequest = {
    import StopDbInstanceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.StopDbInstanceRequest
      .builder()
      .dbInstanceIdentifier(dbInstanceIdentifier: java.lang.String)
      .optionallyWith(
        dbSnapshotIdentifier.map(value => value: java.lang.String)
      )(_.dbSnapshotIdentifier)
      .build()
  }
  def asReadOnly: zio.aws.rds.model.StopDbInstanceRequest.ReadOnly =
    zio.aws.rds.model.StopDbInstanceRequest.wrap(buildAwsValue())
}
object StopDbInstanceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.StopDbInstanceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.StopDbInstanceRequest =
      zio.aws.rds.model.StopDbInstanceRequest(
        dbInstanceIdentifier,
        dbSnapshotIdentifier.map(value => value)
      )
    def dbInstanceIdentifier: String
    def dbSnapshotIdentifier: scala.Option[String]
    def getDbInstanceIdentifier: ZIO[Any, Nothing, String] =
      ZIO.succeed(dbInstanceIdentifier)
    def getDbSnapshotIdentifier: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("dbSnapshotIdentifier", dbSnapshotIdentifier)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.StopDbInstanceRequest
  ) extends zio.aws.rds.model.StopDbInstanceRequest.ReadOnly {
    override val dbInstanceIdentifier: String =
      impl.dbInstanceIdentifier(): String
    override val dbSnapshotIdentifier: scala.Option[String] =
      scala.Option(impl.dbSnapshotIdentifier()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.StopDbInstanceRequest
  ): zio.aws.rds.model.StopDbInstanceRequest.ReadOnly = new Wrapper(impl)
}
