package zio.aws.rds.model
import java.lang.Integer
import zio.aws.rds.model.primitives.IntegerOptional
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class StartDbInstanceAutomatedBackupsReplicationRequest(
    sourceDBInstanceArn: String,
    backupRetentionPeriod: scala.Option[IntegerOptional] = None,
    kmsKeyId: scala.Option[String] = None,
    preSignedUrl: scala.Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.StartDbInstanceAutomatedBackupsReplicationRequest = {
    import StartDbInstanceAutomatedBackupsReplicationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.StartDbInstanceAutomatedBackupsReplicationRequest
      .builder()
      .sourceDBInstanceArn(sourceDBInstanceArn: java.lang.String)
      .optionallyWith(
        backupRetentionPeriod.map(value =>
          IntegerOptional.unwrap(value): Integer
        )
      )(_.backupRetentionPeriod)
      .optionallyWith(kmsKeyId.map(value => value: java.lang.String))(
        _.kmsKeyId
      )
      .optionallyWith(preSignedUrl.map(value => value: java.lang.String))(
        _.preSignedUrl
      )
      .build()
  }
  def asReadOnly
      : zio.aws.rds.model.StartDbInstanceAutomatedBackupsReplicationRequest.ReadOnly =
    zio.aws.rds.model.StartDbInstanceAutomatedBackupsReplicationRequest
      .wrap(buildAwsValue())
}
object StartDbInstanceAutomatedBackupsReplicationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.StartDbInstanceAutomatedBackupsReplicationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.rds.model.StartDbInstanceAutomatedBackupsReplicationRequest =
      zio.aws.rds.model.StartDbInstanceAutomatedBackupsReplicationRequest(
        sourceDBInstanceArn,
        backupRetentionPeriod.map(value => value),
        kmsKeyId.map(value => value),
        preSignedUrl.map(value => value)
      )
    def sourceDBInstanceArn: String
    def backupRetentionPeriod: scala.Option[IntegerOptional]
    def kmsKeyId: scala.Option[String]
    def preSignedUrl: scala.Option[String]
    def getSourceDBInstanceArn: ZIO[Any, Nothing, String] =
      ZIO.succeed(sourceDBInstanceArn)
    def getBackupRetentionPeriod: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("backupRetentionPeriod", backupRetentionPeriod)
    def getKmsKeyId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("kmsKeyId", kmsKeyId)
    def getPreSignedUrl: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("preSignedUrl", preSignedUrl)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.StartDbInstanceAutomatedBackupsReplicationRequest
  ) extends zio.aws.rds.model.StartDbInstanceAutomatedBackupsReplicationRequest.ReadOnly {
    override val sourceDBInstanceArn: String =
      impl.sourceDBInstanceArn(): String
    override val backupRetentionPeriod: scala.Option[IntegerOptional] = scala
      .Option(impl.backupRetentionPeriod())
      .map(value => zio.aws.rds.model.primitives.IntegerOptional(value))
    override val kmsKeyId: scala.Option[String] =
      scala.Option(impl.kmsKeyId()).map(value => value: String)
    override val preSignedUrl: scala.Option[String] =
      scala.Option(impl.preSignedUrl()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.StartDbInstanceAutomatedBackupsReplicationRequest
  ): zio.aws.rds.model.StartDbInstanceAutomatedBackupsReplicationRequest.ReadOnly =
    new Wrapper(impl)
}
