package zio.aws.rds.model
import zio.aws.rds.model.primitives.TStamp
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class PendingMaintenanceAction(
    action: scala.Option[String] = None,
    autoAppliedAfterDate: scala.Option[TStamp] = None,
    forcedApplyDate: scala.Option[TStamp] = None,
    optInStatus: scala.Option[String] = None,
    currentApplyDate: scala.Option[TStamp] = None,
    description: scala.Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.PendingMaintenanceAction = {
    import PendingMaintenanceAction.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.PendingMaintenanceAction
      .builder()
      .optionallyWith(action.map(value => value: java.lang.String))(_.action)
      .optionallyWith(
        autoAppliedAfterDate.map(value => TStamp.unwrap(value): Instant)
      )(_.autoAppliedAfterDate)
      .optionallyWith(
        forcedApplyDate.map(value => TStamp.unwrap(value): Instant)
      )(_.forcedApplyDate)
      .optionallyWith(optInStatus.map(value => value: java.lang.String))(
        _.optInStatus
      )
      .optionallyWith(
        currentApplyDate.map(value => TStamp.unwrap(value): Instant)
      )(_.currentApplyDate)
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .build()
  }
  def asReadOnly: zio.aws.rds.model.PendingMaintenanceAction.ReadOnly =
    zio.aws.rds.model.PendingMaintenanceAction.wrap(buildAwsValue())
}
object PendingMaintenanceAction {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.PendingMaintenanceAction
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.PendingMaintenanceAction =
      zio.aws.rds.model.PendingMaintenanceAction(
        action.map(value => value),
        autoAppliedAfterDate.map(value => value),
        forcedApplyDate.map(value => value),
        optInStatus.map(value => value),
        currentApplyDate.map(value => value),
        description.map(value => value)
      )
    def action: scala.Option[String]
    def autoAppliedAfterDate: scala.Option[TStamp]
    def forcedApplyDate: scala.Option[TStamp]
    def optInStatus: scala.Option[String]
    def currentApplyDate: scala.Option[TStamp]
    def description: scala.Option[String]
    def getAction: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("action", action)
    def getAutoAppliedAfterDate: ZIO[Any, AwsError, TStamp] =
      AwsError.unwrapOptionField("autoAppliedAfterDate", autoAppliedAfterDate)
    def getForcedApplyDate: ZIO[Any, AwsError, TStamp] =
      AwsError.unwrapOptionField("forcedApplyDate", forcedApplyDate)
    def getOptInStatus: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("optInStatus", optInStatus)
    def getCurrentApplyDate: ZIO[Any, AwsError, TStamp] =
      AwsError.unwrapOptionField("currentApplyDate", currentApplyDate)
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.PendingMaintenanceAction
  ) extends zio.aws.rds.model.PendingMaintenanceAction.ReadOnly {
    override val action: scala.Option[String] =
      scala.Option(impl.action()).map(value => value: String)
    override val autoAppliedAfterDate: scala.Option[TStamp] = scala
      .Option(impl.autoAppliedAfterDate())
      .map(value => zio.aws.rds.model.primitives.TStamp(value))
    override val forcedApplyDate: scala.Option[TStamp] = scala
      .Option(impl.forcedApplyDate())
      .map(value => zio.aws.rds.model.primitives.TStamp(value))
    override val optInStatus: scala.Option[String] =
      scala.Option(impl.optInStatus()).map(value => value: String)
    override val currentApplyDate: scala.Option[TStamp] = scala
      .Option(impl.currentApplyDate())
      .map(value => zio.aws.rds.model.primitives.TStamp(value))
    override val description: scala.Option[String] =
      scala.Option(impl.description()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.PendingMaintenanceAction
  ): zio.aws.rds.model.PendingMaintenanceAction.ReadOnly = new Wrapper(impl)
}
