package zio.aws.rds.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ModifyOptionGroupResponse(
    optionGroup: scala.Option[zio.aws.rds.model.OptionGroup] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.ModifyOptionGroupResponse = {
    import ModifyOptionGroupResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.ModifyOptionGroupResponse
      .builder()
      .optionallyWith(optionGroup.map(value => value.buildAwsValue()))(
        _.optionGroup
      )
      .build()
  }
  def asReadOnly: zio.aws.rds.model.ModifyOptionGroupResponse.ReadOnly =
    zio.aws.rds.model.ModifyOptionGroupResponse.wrap(buildAwsValue())
}
object ModifyOptionGroupResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.ModifyOptionGroupResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.ModifyOptionGroupResponse =
      zio.aws.rds.model
        .ModifyOptionGroupResponse(optionGroup.map(value => value.asEditable))
    def optionGroup: scala.Option[zio.aws.rds.model.OptionGroup.ReadOnly]
    def getOptionGroup
        : ZIO[Any, AwsError, zio.aws.rds.model.OptionGroup.ReadOnly] =
      AwsError.unwrapOptionField("optionGroup", optionGroup)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.ModifyOptionGroupResponse
  ) extends zio.aws.rds.model.ModifyOptionGroupResponse.ReadOnly {
    override val optionGroup
        : scala.Option[zio.aws.rds.model.OptionGroup.ReadOnly] = scala
      .Option(impl.optionGroup())
      .map(value => zio.aws.rds.model.OptionGroup.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.ModifyOptionGroupResponse
  ): zio.aws.rds.model.ModifyOptionGroupResponse.ReadOnly = new Wrapper(impl)
}
