package zio.aws.rds.model
import zio.aws.rds.model.primitives.TStamp
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class Event(
    sourceIdentifier: scala.Option[String] = None,
    sourceType: scala.Option[zio.aws.rds.model.SourceType] = None,
    message: scala.Option[String] = None,
    eventCategories: scala.Option[Iterable[String]] = None,
    date: scala.Option[TStamp] = None,
    sourceArn: scala.Option[String] = None
) {
  def buildAwsValue(): software.amazon.awssdk.services.rds.model.Event = {
    import Event.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.Event
      .builder()
      .optionallyWith(sourceIdentifier.map(value => value: java.lang.String))(
        _.sourceIdentifier
      )
      .optionallyWith(sourceType.map(value => value.unwrap))(_.sourceType)
      .optionallyWith(message.map(value => value: java.lang.String))(_.message)
      .optionallyWith(
        eventCategories.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.eventCategories)
      .optionallyWith(date.map(value => TStamp.unwrap(value): Instant))(_.date)
      .optionallyWith(sourceArn.map(value => value: java.lang.String))(
        _.sourceArn
      )
      .build()
  }
  def asReadOnly: zio.aws.rds.model.Event.ReadOnly =
    zio.aws.rds.model.Event.wrap(buildAwsValue())
}
object Event {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.rds.model.Event] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.Event = zio.aws.rds.model.Event(
      sourceIdentifier.map(value => value),
      sourceType.map(value => value),
      message.map(value => value),
      eventCategories.map(value => value),
      date.map(value => value),
      sourceArn.map(value => value)
    )
    def sourceIdentifier: scala.Option[String]
    def sourceType: scala.Option[zio.aws.rds.model.SourceType]
    def message: scala.Option[String]
    def eventCategories: scala.Option[List[String]]
    def date: scala.Option[TStamp]
    def sourceArn: scala.Option[String]
    def getSourceIdentifier: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("sourceIdentifier", sourceIdentifier)
    def getSourceType: ZIO[Any, AwsError, zio.aws.rds.model.SourceType] =
      AwsError.unwrapOptionField("sourceType", sourceType)
    def getMessage: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("message", message)
    def getEventCategories: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("eventCategories", eventCategories)
    def getDate: ZIO[Any, AwsError, TStamp] =
      AwsError.unwrapOptionField("date", date)
    def getSourceArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("sourceArn", sourceArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.Event
  ) extends zio.aws.rds.model.Event.ReadOnly {
    override val sourceIdentifier: scala.Option[String] =
      scala.Option(impl.sourceIdentifier()).map(value => value: String)
    override val sourceType: scala.Option[zio.aws.rds.model.SourceType] = scala
      .Option(impl.sourceType())
      .map(value => zio.aws.rds.model.SourceType.wrap(value))
    override val message: scala.Option[String] =
      scala.Option(impl.message()).map(value => value: String)
    override val eventCategories: scala.Option[List[String]] = scala
      .Option(impl.eventCategories())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val date: scala.Option[TStamp] = scala
      .Option(impl.date())
      .map(value => zio.aws.rds.model.primitives.TStamp(value))
    override val sourceArn: scala.Option[String] =
      scala.Option(impl.sourceArn()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.Event
  ): zio.aws.rds.model.Event.ReadOnly = new Wrapper(impl)
}
