package zio.aws.rds.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeGlobalClustersResponse(
    marker: scala.Option[String] = None,
    globalClusters: scala.Option[Iterable[zio.aws.rds.model.GlobalCluster]] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.DescribeGlobalClustersResponse = {
    import DescribeGlobalClustersResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.DescribeGlobalClustersResponse
      .builder()
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .optionallyWith(
        globalClusters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.globalClusters)
      .build()
  }
  def asReadOnly: zio.aws.rds.model.DescribeGlobalClustersResponse.ReadOnly =
    zio.aws.rds.model.DescribeGlobalClustersResponse.wrap(buildAwsValue())
}
object DescribeGlobalClustersResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.DescribeGlobalClustersResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.DescribeGlobalClustersResponse =
      zio.aws.rds.model.DescribeGlobalClustersResponse(
        marker.map(value => value),
        globalClusters.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def marker: scala.Option[String]
    def globalClusters
        : scala.Option[List[zio.aws.rds.model.GlobalCluster.ReadOnly]]
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
    def getGlobalClusters
        : ZIO[Any, AwsError, List[zio.aws.rds.model.GlobalCluster.ReadOnly]] =
      AwsError.unwrapOptionField("globalClusters", globalClusters)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.DescribeGlobalClustersResponse
  ) extends zio.aws.rds.model.DescribeGlobalClustersResponse.ReadOnly {
    override val marker: scala.Option[String] =
      scala.Option(impl.marker()).map(value => value: String)
    override val globalClusters
        : scala.Option[List[zio.aws.rds.model.GlobalCluster.ReadOnly]] = scala
      .Option(impl.globalClusters())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.rds.model.GlobalCluster.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.DescribeGlobalClustersResponse
  ): zio.aws.rds.model.DescribeGlobalClustersResponse.ReadOnly = new Wrapper(
    impl
  )
}
