package zio.aws.rds.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DeleteDbProxyResponse(
    dbProxy: scala.Option[zio.aws.rds.model.DBProxy] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.DeleteDbProxyResponse = {
    import DeleteDbProxyResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.DeleteDbProxyResponse
      .builder()
      .optionallyWith(dbProxy.map(value => value.buildAwsValue()))(_.dbProxy)
      .build()
  }
  def asReadOnly: zio.aws.rds.model.DeleteDbProxyResponse.ReadOnly =
    zio.aws.rds.model.DeleteDbProxyResponse.wrap(buildAwsValue())
}
object DeleteDbProxyResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.DeleteDbProxyResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.DeleteDbProxyResponse = zio.aws.rds.model
      .DeleteDbProxyResponse(dbProxy.map(value => value.asEditable))
    def dbProxy: scala.Option[zio.aws.rds.model.DBProxy.ReadOnly]
    def getDbProxy: ZIO[Any, AwsError, zio.aws.rds.model.DBProxy.ReadOnly] =
      AwsError.unwrapOptionField("dbProxy", dbProxy)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.DeleteDbProxyResponse
  ) extends zio.aws.rds.model.DeleteDbProxyResponse.ReadOnly {
    override val dbProxy: scala.Option[zio.aws.rds.model.DBProxy.ReadOnly] =
      scala
        .Option(impl.dbProxy())
        .map(value => zio.aws.rds.model.DBProxy.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.DeleteDbProxyResponse
  ): zio.aws.rds.model.DeleteDbProxyResponse.ReadOnly = new Wrapper(impl)
}
