package zio.aws.rds.model
import zio.aws.rds.model.primitives.TStamp
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class DBProxyTargetGroup(
    dbProxyName: scala.Option[String] = None,
    targetGroupName: scala.Option[String] = None,
    targetGroupArn: scala.Option[String] = None,
    isDefault: scala.Option[Boolean] = None,
    status: scala.Option[String] = None,
    connectionPoolConfig: scala.Option[
      zio.aws.rds.model.ConnectionPoolConfigurationInfo
    ] = None,
    createdDate: scala.Option[TStamp] = None,
    updatedDate: scala.Option[TStamp] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.DBProxyTargetGroup = {
    import DBProxyTargetGroup.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.DBProxyTargetGroup
      .builder()
      .optionallyWith(dbProxyName.map(value => value: java.lang.String))(
        _.dbProxyName
      )
      .optionallyWith(targetGroupName.map(value => value: java.lang.String))(
        _.targetGroupName
      )
      .optionallyWith(targetGroupArn.map(value => value: java.lang.String))(
        _.targetGroupArn
      )
      .optionallyWith(isDefault.map(value => value: java.lang.Boolean))(
        _.isDefault
      )
      .optionallyWith(status.map(value => value: java.lang.String))(_.status)
      .optionallyWith(connectionPoolConfig.map(value => value.buildAwsValue()))(
        _.connectionPoolConfig
      )
      .optionallyWith(createdDate.map(value => TStamp.unwrap(value): Instant))(
        _.createdDate
      )
      .optionallyWith(updatedDate.map(value => TStamp.unwrap(value): Instant))(
        _.updatedDate
      )
      .build()
  }
  def asReadOnly: zio.aws.rds.model.DBProxyTargetGroup.ReadOnly =
    zio.aws.rds.model.DBProxyTargetGroup.wrap(buildAwsValue())
}
object DBProxyTargetGroup {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.DBProxyTargetGroup
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.DBProxyTargetGroup =
      zio.aws.rds.model.DBProxyTargetGroup(
        dbProxyName.map(value => value),
        targetGroupName.map(value => value),
        targetGroupArn.map(value => value),
        isDefault.map(value => value),
        status.map(value => value),
        connectionPoolConfig.map(value => value.asEditable),
        createdDate.map(value => value),
        updatedDate.map(value => value)
      )
    def dbProxyName: scala.Option[String]
    def targetGroupName: scala.Option[String]
    def targetGroupArn: scala.Option[String]
    def isDefault: scala.Option[Boolean]
    def status: scala.Option[String]
    def connectionPoolConfig: scala.Option[
      zio.aws.rds.model.ConnectionPoolConfigurationInfo.ReadOnly
    ]
    def createdDate: scala.Option[TStamp]
    def updatedDate: scala.Option[TStamp]
    def getDbProxyName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("dbProxyName", dbProxyName)
    def getTargetGroupName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("targetGroupName", targetGroupName)
    def getTargetGroupArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("targetGroupArn", targetGroupArn)
    def getIsDefault: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("isDefault", isDefault)
    def getStatus: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("status", status)
    def getConnectionPoolConfig: ZIO[
      Any,
      AwsError,
      zio.aws.rds.model.ConnectionPoolConfigurationInfo.ReadOnly
    ] = AwsError.unwrapOptionField("connectionPoolConfig", connectionPoolConfig)
    def getCreatedDate: ZIO[Any, AwsError, TStamp] =
      AwsError.unwrapOptionField("createdDate", createdDate)
    def getUpdatedDate: ZIO[Any, AwsError, TStamp] =
      AwsError.unwrapOptionField("updatedDate", updatedDate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.DBProxyTargetGroup
  ) extends zio.aws.rds.model.DBProxyTargetGroup.ReadOnly {
    override val dbProxyName: scala.Option[String] =
      scala.Option(impl.dbProxyName()).map(value => value: String)
    override val targetGroupName: scala.Option[String] =
      scala.Option(impl.targetGroupName()).map(value => value: String)
    override val targetGroupArn: scala.Option[String] =
      scala.Option(impl.targetGroupArn()).map(value => value: String)
    override val isDefault: scala.Option[Boolean] =
      scala.Option(impl.isDefault()).map(value => value: Boolean)
    override val status: scala.Option[String] =
      scala.Option(impl.status()).map(value => value: String)
    override val connectionPoolConfig: scala.Option[
      zio.aws.rds.model.ConnectionPoolConfigurationInfo.ReadOnly
    ] = scala
      .Option(impl.connectionPoolConfig())
      .map(value =>
        zio.aws.rds.model.ConnectionPoolConfigurationInfo.wrap(value)
      )
    override val createdDate: scala.Option[TStamp] = scala
      .Option(impl.createdDate())
      .map(value => zio.aws.rds.model.primitives.TStamp(value))
    override val updatedDate: scala.Option[TStamp] = scala
      .Option(impl.updatedDate())
      .map(value => zio.aws.rds.model.primitives.TStamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.DBProxyTargetGroup
  ): zio.aws.rds.model.DBProxyTargetGroup.ReadOnly = new Wrapper(impl)
}
