package zio.aws.rds.model
import scala.jdk.CollectionConverters._
sealed trait DBProxyEndpointStatus {
  def unwrap: software.amazon.awssdk.services.rds.model.DBProxyEndpointStatus
}
object DBProxyEndpointStatus {
  def wrap(
      value: software.amazon.awssdk.services.rds.model.DBProxyEndpointStatus
  ): zio.aws.rds.model.DBProxyEndpointStatus = value match {
    case software.amazon.awssdk.services.rds.model.DBProxyEndpointStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.rds.model.DBProxyEndpointStatus.AVAILABLE =>
      val r = available
      r
    case software.amazon.awssdk.services.rds.model.DBProxyEndpointStatus.MODIFYING =>
      val r = modifying
      r
    case software.amazon.awssdk.services.rds.model.DBProxyEndpointStatus.INCOMPATIBLE_NETWORK =>
      val r = `incompatible-network`
      r
    case software.amazon.awssdk.services.rds.model.DBProxyEndpointStatus.INSUFFICIENT_RESOURCE_LIMITS =>
      val r = `insufficient-resource-limits`
      r
    case software.amazon.awssdk.services.rds.model.DBProxyEndpointStatus.CREATING =>
      val r = creating
      r
    case software.amazon.awssdk.services.rds.model.DBProxyEndpointStatus.DELETING =>
      val r = deleting
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.rds.model.DBProxyEndpointStatus {
    override def unwrap
        : software.amazon.awssdk.services.rds.model.DBProxyEndpointStatus =
      software.amazon.awssdk.services.rds.model.DBProxyEndpointStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object available extends zio.aws.rds.model.DBProxyEndpointStatus {
    override def unwrap
        : software.amazon.awssdk.services.rds.model.DBProxyEndpointStatus =
      software.amazon.awssdk.services.rds.model.DBProxyEndpointStatus.AVAILABLE
  }
  case object modifying extends zio.aws.rds.model.DBProxyEndpointStatus {
    override def unwrap
        : software.amazon.awssdk.services.rds.model.DBProxyEndpointStatus =
      software.amazon.awssdk.services.rds.model.DBProxyEndpointStatus.MODIFYING
  }
  case object `incompatible-network`
      extends zio.aws.rds.model.DBProxyEndpointStatus {
    override def unwrap
        : software.amazon.awssdk.services.rds.model.DBProxyEndpointStatus =
      software.amazon.awssdk.services.rds.model.DBProxyEndpointStatus.INCOMPATIBLE_NETWORK
  }
  case object `insufficient-resource-limits`
      extends zio.aws.rds.model.DBProxyEndpointStatus {
    override def unwrap
        : software.amazon.awssdk.services.rds.model.DBProxyEndpointStatus =
      software.amazon.awssdk.services.rds.model.DBProxyEndpointStatus.INSUFFICIENT_RESOURCE_LIMITS
  }
  case object creating extends zio.aws.rds.model.DBProxyEndpointStatus {
    override def unwrap
        : software.amazon.awssdk.services.rds.model.DBProxyEndpointStatus =
      software.amazon.awssdk.services.rds.model.DBProxyEndpointStatus.CREATING
  }
  case object deleting extends zio.aws.rds.model.DBProxyEndpointStatus {
    override def unwrap
        : software.amazon.awssdk.services.rds.model.DBProxyEndpointStatus =
      software.amazon.awssdk.services.rds.model.DBProxyEndpointStatus.DELETING
  }
}
